/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.configuration;

import com.openexchange.config.ConfigurationService;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParticipantConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ParticipantConfig.class);
    private static final ParticipantConfig SINGLETON = new ParticipantConfig();
    private static final String FILENAME = "participant.properties";
    private final Properties props = new Properties();

    private ParticipantConfig() {
    }

    public Boolean getProperty(Property key) {
        this.logNotInitialized();
        return Boolean.valueOf(this.props.getProperty(key.name, key.value));
    }

    public Integer getIntProperty(Property key) {
        this.logNotInitialized();
        return Integer.valueOf(this.props.getProperty(key.name, key.value));
    }

    public static ParticipantConfig getInstance() {
        return SINGLETON;
    }

    public void initialize(ConfigurationService configuration) {
        Properties props = configuration.getFile(FILENAME);
        if (null == props) {
            LOG.info("Configuration file {} is missing. Using defaults.", (Object)FILENAME);
        } else {
            this.props.clear();
            this.props.putAll((Map<?, ?>)props);
            LOG.info("Read configuration file {}.", (Object)FILENAME);
        }
    }

    private void logNotInitialized() {
        if (this.props.isEmpty()) {
            LOG.info("Configuration file {} not read. Using defaults.", (Object)FILENAME);
        }
    }

    public static enum Property {
        SHOW_WITHOUT_EMAIL("com.openexchange.participant.ShowWithoutEmail", Boolean.TRUE.toString()),
        AUTO_SEARCH("com.openexchange.participant.autoSearch", Boolean.TRUE.toString()),
        MAXIMUM_NUMBER_PARTICIPANTS("com.openexchange.participant.MaximumNumberParticipants", "0");

        private String name;
        private String value;

        private Property(String keyName, String value) {
            this.name = keyName;
            this.value = value;
        }
    }
}

