/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.i18n.Localizable;
import com.openexchange.i18n.LocalizableArgument;

public enum CalendarField {
    OBJECTID(1, "ObjectID", "intfield01"),
    CREATEDBY(2, "CreatedBy", "created_from"),
    CREATIONDATE(4, "CreationDate", "creating_date"),
    MODIFIEDBY(3, "ModifiedBy", "changed_from"),
    LASTMODIFIED(5, "LastModified", "changing_date"),
    PARENTFOLDERID(20, "ParentFolderID", "fid"),
    TITLE(200, "Title", "field01"),
    STARTDATE(201, "StartDate", "timestampfield01"),
    ENDDATE(202, "EndDate", "timestampfield02"),
    SHOWNAS(402, "ShownAs", "intfield06"),
    LOCATION(400, "Location", "field02"),
    CATEGORIES(100, "Categories", "field09"),
    LABEL(102, "Label", "intfield03"),
    PRIVATEFLAG(101, "PrivateFlag", "pflag"),
    FULLTIME(401, "FullTime", "intfield07"),
    NOTE(203, "Note", "field04"),
    RECURRENCETYPE(209, "RecurrenceType", null),
    INTERVAL(215, "Interval", null),
    DAYS(212, "Days", null),
    DAYINMONTH(213, "DayInMonth", null),
    MONTH(214, "Month", null),
    UNTIL(216, "Until", null),
    OCCURRENCE(222, "Occurrence", null),
    RECURRENCEDATEPOSITION(208, "RecurrenceDatePosition", null),
    RECURRENCEPOSITION(207, "RecurrencePosition", null),
    TIMEZONE(408, "Timezone", "timezone"),
    CHANGEEXCEPTION(210, "ChangeExceptions", "field08"),
    DELETEEXCEPTION(211, "DeleteExceptions", "field07"),
    PARTICIPANTS(220, "Participants", null),
    USERS(221, "Users", null),
    RECURRENCECALCULATOR(218, "RecurrenceCalculator", "intfield04"),
    ALARM(204, "Alarm", null);

    private final int appointmentObjectID;
    private final String name;
    private final String dbField;

    private CalendarField(int appointmentObjectID, String name, String dbField) {
        this.appointmentObjectID = appointmentObjectID;
        this.name = name;
        this.dbField = dbField;
    }

    public static CalendarField getByAppointmentObjectId(int id) {
        for (CalendarField field : CalendarField.values()) {
            if (id != field.getAppointmentObjectID()) continue;
            return field;
        }
        return null;
    }

    public static CalendarField getByName(String name) {
        for (CalendarField field : CalendarField.values()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static CalendarField getByDbField(String dbField) {
        if (null == dbField) {
            return null;
        }
        for (CalendarField field : CalendarField.values()) {
            if (!dbField.equals(field.dbField)) continue;
            return field;
        }
        return null;
    }

    public int getAppointmentObjectID() {
        return this.appointmentObjectID;
    }

    public String getName() {
        return this.name;
    }

    public Localizable getLocalizable() {
        return new LocalizableArgument(this.getName());
    }

    public String getICalElement() {
        return this.name;
    }

    public String getdbField() {
        return this.dbField;
    }
}

