/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.event.impl.AppointmentEventInterface;
import com.openexchange.event.impl.ContactEventInterface;
import com.openexchange.event.impl.NoDelayEventInterface;
import com.openexchange.event.impl.TaskEventInterface;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentBaseImpl;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import gnu.trove.list.array.TIntArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentCleaner
implements AppointmentEventInterface,
TaskEventInterface,
ContactEventInterface,
NoDelayEventInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentCleaner.class);
    private static final AttachmentBase ATTACHMENT_BASE = new AttachmentBaseImpl(new DBPoolProvider());

    @Override
    public final void appointmentDeleted(Appointment appointmentObj, Session sessionObj) {
        this.deleteAttachments(appointmentObj.getParentFolderID(), appointmentObj.getObjectID(), 1, sessionObj);
    }

    @Override
    public final void taskDeleted(Task taskObj, Session sessionObj) {
        this.deleteAttachments(taskObj.getParentFolderID(), taskObj.getObjectID(), 4, sessionObj);
    }

    @Override
    public final void contactDeleted(Contact contactObj, Session sessionObj) {
        this.deleteAttachments(contactObj.getParentFolderID(), contactObj.getObjectID(), 7, sessionObj);
    }

    @Override
    public final void appointmentCreated(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public final void appointmentModified(Appointment appointment, Session session) {
    }

    @Override
    public final void taskCreated(Task taskObj, Session sessionObj) {
    }

    @Override
    public final void taskModified(Task taskObj, Session sessionObj) {
    }

    @Override
    public final void contactCreated(Contact contactObj, Session sessionObj) {
    }

    @Override
    public final void contactModified(Contact contact, Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void deleteAttachments(int parentFolderID, int objectID, int type, Session session) {
        SearchIterator iter;
        block17: {
            block16: {
                iter = null;
                try {
                    ServerSession sessionObj = ServerSessionAdapter.valueOf(session);
                    ATTACHMENT_BASE.startTransaction();
                    TimedResult<AttachmentMetadata> rs = ATTACHMENT_BASE.getAttachments(session, parentFolderID, objectID, type, new AttachmentField[]{AttachmentField.ID_LITERAL}, AttachmentField.ID_LITERAL, 1, sessionObj.getContext(), null, null);
                    TIntArrayList ids = new TIntArrayList();
                    iter = rs.results();
                    if (!iter.hasNext()) {
                        SearchIterators.close((SearchIterator)iter);
                        break block16;
                    }
                    do {
                        ids.add(((AttachmentMetadata)iter.next()).getId());
                    } while (iter.hasNext());
                    ATTACHMENT_BASE.detachFromObject(parentFolderID, objectID, type, ids.toArray(), sessionObj, sessionObj.getContext(), null, null);
                    ATTACHMENT_BASE.commit();
                    SearchIterators.close((SearchIterator)iter);
                    break block17;
                }
                catch (OXException e) {
                    this.rollback(e);
                    return;
                }
            }
            try {
                ATTACHMENT_BASE.finish();
                return;
            }
            catch (OXException e) {
                this.log(e);
            }
            return;
        }
        try {
            ATTACHMENT_BASE.finish();
            return;
        }
        catch (OXException e) {
            this.log(e);
            return;
        }
        finally {
            SearchIterators.close(iter);
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                this.log(e);
            }
        }
    }

    private void log(OXException e) {
        switch (((Category)e.getCategories().get(0)).getLogLevel()) {
            case TRACE: {
                LOG.trace("", (Throwable)e);
                break;
            }
            case DEBUG: {
                LOG.debug("", (Throwable)e);
                break;
            }
            case INFO: {
                LOG.info("", (Throwable)e);
                break;
            }
            case WARNING: {
                LOG.warn("", (Throwable)e);
                break;
            }
            case ERROR: {
                LOG.error("", (Throwable)e);
                break;
            }
        }
    }

    private void rollback(OXException x) {
        try {
            ATTACHMENT_BASE.rollback();
        }
        catch (OXException e) {
            this.log(e);
        }
        this.log(x);
    }

    @Override
    public void appointmentAccepted(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void appointmentDeclined(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void appointmentTentativelyAccepted(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void appointmentWaiting(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void taskAccepted(Task taskObj, Session sessionObj) {
    }

    @Override
    public void taskDeclined(Task taskObj, Session sessionObj) {
    }

    @Override
    public void taskTentativelyAccepted(Task taskObj, Session sessionObj) {
    }
}

