/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.json.actions;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.json.GroupAJAXRequest;
import com.openexchange.group.json.actions.AbstractGroupAction;
import com.openexchange.server.ServiceLookup;
import java.util.Date;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="list", description="List groups", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="An array with group identifiers.", responseDescription="An array of group objects as described in Group data.")
public final class ListAction
extends AbstractGroupAction {
    public ListAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(GroupAJAXRequest req) throws OXException, JSONException {
        JSONArray jBody = (JSONArray)req.getData();
        Date timestamp = new Date(0L);
        Date lastModified = null;
        LinkedList<Group> groupList = new LinkedList<Group>();
        GroupStorage groupStorage = GroupStorage.getInstance();
        int length = jBody.length();
        for (int a = 0; a < length; ++a) {
            JSONObject jData = jBody.getJSONObject(a);
            Group group = groupStorage.getGroup(DataParser.checkInt(jData, "id"), req.getSession().getContext());
            groupList.add(group);
            lastModified = group.getLastModified();
            if (null == lastModified || timestamp.getTime() >= lastModified.getTime()) continue;
            timestamp = lastModified;
        }
        return new AJAXRequestResult(groupList, timestamp, "group");
    }
}

