/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.json.GroupAJAXRequest;
import com.openexchange.group.json.actions.AbstractGroupAction;
import com.openexchange.server.ServiceLookup;
import java.util.Date;
import java.util.LinkedList;
import org.json.JSONException;

@Action(method=RequestMethod.GET, name="all", description="Get all groups", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="The group id.")}, responseDescription="An array of group objects as described in Group data.")
public final class AllAction
extends AbstractGroupAction {
    public AllAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(GroupAJAXRequest req) throws OXException, JSONException {
        int[] columns;
        Date timestamp = new Date(0L);
        LinkedList<Group.Field> fields = new LinkedList<Group.Field>();
        boolean loadMembers = false;
        for (int column : columns = req.checkIntArray("columns")) {
            Group.Field field = Group.Field.getByColumnNumber(column);
            if (field == Group.Field.MEMBERS) {
                loadMembers = true;
            }
            fields.add(field);
        }
        GroupStorage groupStorage = GroupStorage.getInstance();
        Group[] groups = groupStorage.getGroups(loadMembers, req.getSession().getContext());
        LinkedList<Group> groupList = new LinkedList<Group>();
        for (int a = 0; a < groups.length; ++a) {
            Group group = groups[a];
            groupList.add(group);
            Date lastModified = group.getLastModified();
            if (null == lastModified || !lastModified.after(timestamp)) continue;
            timestamp = lastModified;
        }
        return new AJAXRequestResult(groupList, timestamp, "group");
    }
}

