/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.messaging;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.messaging.MessagingFolderIdentifier;
import com.openexchange.folderstorage.messaging.osgi.Services;
import com.openexchange.messaging.registry.MessagingServiceRegistry;

public final class MessagingFolderType
implements FolderType {
    private static final MessagingFolderType instance = new MessagingFolderType();
    private static final String PRIVATE_FOLDER_ID = String.valueOf(1);

    public static MessagingFolderType getInstance() {
        return instance;
    }

    private MessagingFolderType() {
    }

    @Override
    public boolean servesTreeId(String treeId) {
        return FolderStorage.REAL_TREE_ID.equals(treeId);
    }

    @Override
    public boolean servesFolderId(String folderId) {
        MessagingFolderIdentifier pfi;
        if (null == folderId) {
            return false;
        }
        try {
            pfi = new MessagingFolderIdentifier(folderId);
        }
        catch (OXException e) {
            return false;
        }
        MessagingServiceRegistry registry = Services.getService(MessagingServiceRegistry.class);
        if (null == registry) {
            return false;
        }
        return registry.containsMessagingService(pfi.getServiceId(), -1, -1);
    }

    @Override
    public boolean servesParentId(String folderId) {
        if (null == folderId) {
            return false;
        }
        if (PRIVATE_FOLDER_ID.equals(folderId)) {
            return true;
        }
        return this.servesFolderId(folderId);
    }
}

