/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.mail;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.RemoveAfterAccessFolder;
import com.openexchange.folderstorage.RemoveAfterAccessFolderWrapper;
import com.openexchange.folderstorage.SetterAwareFolder;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StorageParametersUtility;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.mail.DummyFolder;
import com.openexchange.folderstorage.mail.ExternalMailAccountRootFolder;
import com.openexchange.folderstorage.mail.MailAccessFullnameProvider;
import com.openexchange.folderstorage.mail.MailFolderImpl;
import com.openexchange.folderstorage.mail.MailFolderType;
import com.openexchange.folderstorage.mail.MailId;
import com.openexchange.folderstorage.mail.RemoveAfterAccessExtRootFolder;
import com.openexchange.folderstorage.mail.contentType.DraftsContentType;
import com.openexchange.folderstorage.mail.contentType.MailContentType;
import com.openexchange.folderstorage.mail.contentType.SentContentType;
import com.openexchange.folderstorage.mail.contentType.SpamContentType;
import com.openexchange.folderstorage.mail.contentType.TrashContentType;
import com.openexchange.folderstorage.mail.osgi.Services;
import com.openexchange.folderstorage.type.MailType;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.ldap.User;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Collators;
import com.openexchange.java.Strings;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailFolderStorageEnhanced;
import com.openexchange.mail.api.IMailFolderStorageInfoSupport;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.IMailMessageStorageExt;
import com.openexchange.mail.api.IMailMessageStorageMimeSupport;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.api.MailProvider;
import com.openexchange.mail.cache.MailMessageCache;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailFolderInfo;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.event.EventPool;
import com.openexchange.mail.event.PooledEvent;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.mailaccount.internal.RdbMailAccountStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.mail.Message;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailFolderStorage
implements FolderStorage {
    private static final Logger LOG = LoggerFactory.getLogger(MailFolderStorage.class);
    private static final String PRIVATE_FOLDER_ID = String.valueOf(1);
    private final TObjectProcedure<MailAccess<?, ?>> procedure;
    private final MailFolderType folderType = MailFolderType.getInstance();
    private final String paramAccessFast = "__accessFast";
    private static final Set<String> IGNORABLES = RemoveAfterAccessFolder.IGNORABLES;
    private static final String INVALID = "<>";

    public MailFolderStorage() {
        this.procedure = new TObjectProcedure<MailAccess<?, ?>>(){

            public boolean execute(MailAccess<?, ?> mailAccess) {
                MailFolderStorage.closeMailAccess(mailAccess);
                return true;
            }
        };
    }

    private MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccessFor(Session ses, int accountId) throws OXException {
        return MailAccess.getInstance(ses, accountId);
    }

    private static String optArchiveFullName(MailAccount mailAccount, MailAccess<?, ?> mailAccess) throws OXException {
        if (null == mailAccount) {
            return null;
        }
        String fn = mailAccount.getArchiveFullname();
        if (null == fn) {
            String name = mailAccount.getArchive();
            if (null == name) {
                return null;
            }
            fn = mailAccess.getFolderStorage().getDefaultFolderPrefix() + name;
        }
        return fn;
    }

    private boolean isDefaultFolder(String fullName, MailAccess<?, ?> mailAccess) throws OXException {
        MailAccountStorageService storageService;
        MailAccount mailAccount;
        if (null == fullName) {
            return false;
        }
        Session session = mailAccess.getSession();
        MailSessionCache mailSessionCache = MailSessionCache.getInstance(session);
        String[] arr = (String[])mailSessionCache.getParameter(mailAccess.getAccountId(), MailSessionParameterNames.getParamDefaultFolderArray());
        if (null == arr) {
            Object folderStorage = mailAccess.getFolderStorage();
            if (fullName.equals(folderStorage.getConfirmedHamFolder())) {
                return true;
            }
            if (fullName.equals(folderStorage.getConfirmedSpamFolder())) {
                return true;
            }
            if (fullName.equals(folderStorage.getDraftsFolder())) {
                return true;
            }
            if (fullName.equals(folderStorage.getSentFolder())) {
                return true;
            }
            if (fullName.equals(folderStorage.getSpamFolder())) {
                return true;
            }
            if (fullName.equals(folderStorage.getTrashFolder())) {
                return true;
            }
        } else {
            for (String defaultFolderFullName : arr) {
                if (!fullName.equals(defaultFolderFullName)) continue;
                return true;
            }
        }
        return MailFolderStorage.isArchiveFolder(fullName, mailAccess, mailAccount = (storageService = Services.getService(MailAccountStorageService.class)).getMailAccount(mailAccess.getAccountId(), session.getUserId(), session.getContextId()));
    }

    public static boolean isArchiveFolder(String fullName, MailAccess<?, ?> mailAccess, MailAccount mailAccount) throws OXException {
        return fullName.equals(MailFolderStorage.optArchiveFullName(mailAccount, mailAccess));
    }

    @Override
    public void clearCache(int userId, int contextId) {
    }

    @Override
    public void checkConsistency(String treeId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[]{MailContentType.getInstance(), DraftsContentType.getInstance(), SentContentType.getInstance(), SpamContentType.getInstance(), TrashContentType.getInstance()};
    }

    @Override
    public ContentType getDefaultContentType() {
        return MailContentType.getInstance();
    }

    @Override
    public void commitTransaction(StorageParameters params) throws OXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortableId[] getVisibleFolders(String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        if (!MailType.getInstance().equals(type) && !PrivateType.getInstance().equals(type)) {
            return new SortableId[0];
        }
        if (!MailContentType.getInstance().toString().equals(contentType.toString())) {
            return new SortableId[0];
        }
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = null;
        try {
            IMailFolderStorageInfoSupport infoSupport;
            boolean accountId = false;
            ServerSession session = MailFolderStorage.getServerSession(storageParameters);
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            if (this.cannotConnect(session)) {
                SortableId[] sortableIdArray = new SortableId[]{};
                return sortableIdArray;
            }
            mailAccess = this.mailAccessFor(session, 0);
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            mailAccess.connect(null == accessFast ? true : accessFast == false);
            IMailFolderStorage folderStorage = mailAccess.getFolderStorage();
            if (folderStorage instanceof IMailFolderStorageInfoSupport && (infoSupport = (IMailFolderStorageInfoSupport)folderStorage).isInfoSupported()) {
                List<MailFolderInfo> folderInfos = infoSupport.getAllFolderInfos(false);
                boolean translate = !StorageParametersUtility.getBoolParameter("ignoreTranslation", storageParameters);
                Collections.sort(folderInfos, new SimpleMailFolderInfoComparator(storageParameters.getUser().getLocale(), translate));
                int size = folderInfos.size();
                ArrayList<MailId> list = new ArrayList<MailId>(size);
                FolderServiceDecorator decorator = storageParameters.getDecorator();
                if (null == decorator) {
                    for (int j = 0; j < size; ++j) {
                        MailFolderInfo mfi = folderInfos.get(j);
                        list.add(new MailId(MailFolderUtility.prepareFullname(mailAccess.getAccountId(), mfi.getFullname()), j).setName(translate ? mfi.getDisplayName() : mfi.getName()));
                    }
                } else {
                    List accountList;
                    Object property = decorator.getProperty("mailRootFolders");
                    if (property != null && Boolean.parseBoolean(property.toString()) && session.getUserPermissionBits().isMultipleMailAccounts()) {
                        MailAccountStorageService mass = Services.getService(MailAccountStorageService.class);
                        MailAccount[] accounts = mass.getUserMailAccounts(storageParameters.getUserId(), storageParameters.getContextId());
                        accountList = new ArrayList(accounts.length);
                        for (MailAccount mailAccount : accounts) {
                            if (mailAccount.isDefaultAccount()) continue;
                            accountList.add(mailAccount);
                        }
                        Collections.sort(accountList, new MailAccountComparator(session.getUser().getLocale()));
                        if (!accountList.isEmpty() && UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(((MailAccount)accountList.get(0)).getMailProtocol())) {
                            boolean suppressUnifiedMail = StorageParametersUtility.getBoolParameter("suppressUnifiedMail", storageParameters);
                            UnifiedInboxManagement uim = Services.getService(UnifiedInboxManagement.class);
                            if (suppressUnifiedMail || null == uim || !uim.isEnabled(session.getUserId(), session.getContextId())) {
                                accountList.remove(0);
                            } else {
                                MailAccount unifiedMailAccount = (MailAccount)accountList.remove(0);
                                list.add(0, new MailId(MailFolderUtility.prepareFullname(unifiedMailAccount.getId(), "default"), 0).setName("E-Mail"));
                            }
                        }
                    } else {
                        accountList = Collections.emptyList();
                    }
                    int start = list.size();
                    for (int j = 0; j < size; ++j) {
                        MailFolderInfo mfi = folderInfos.get(j);
                        list.add(new MailId(MailFolderUtility.prepareFullname(mailAccess.getAccountId(), mfi.getFullname()), start++).setName(translate ? mfi.getDisplayName() : mfi.getName()));
                    }
                    int sz = accountList.size();
                    for (int j = 0; j < sz; ++j) {
                        list.add(new MailId(MailFolderUtility.prepareFullname(((MailAccount)accountList.get(j)).getId(), "default"), start++).setName("E-Mail"));
                    }
                }
                SortableId[] accountList = list.toArray(new SortableId[list.size()]);
                return accountList;
            }
            ArrayList<MailFolder> folders2 = new ArrayList<MailFolder>(32);
            MailFolder rootFolder = mailAccess.getRootFolder();
            folders2.add(rootFolder);
            MailFolderStorage.addSubfolders("default", folders2, mailAccess.getFolderStorage());
            Collections.sort(folders2, new SimpleMailFolderComparator(storageParameters.getUser().getLocale()));
            int size = folders2.size();
            ArrayList<MailId> list = new ArrayList<MailId>(size);
            FolderServiceDecorator decorator = storageParameters.getDecorator();
            if (null == decorator) {
                for (int j = 0; j < size; ++j) {
                    MailFolder mf = (MailFolder)folders2.get(j);
                    list.add(new MailId(MailFolderUtility.prepareFullname(mailAccess.getAccountId(), mf.getFullname()), j).setName(mf.getName()));
                }
            } else {
                List accountList;
                Object property = decorator.getProperty("mailRootFolders");
                if (property != null && Boolean.parseBoolean(property.toString()) && session.getUserPermissionBits().isMultipleMailAccounts()) {
                    MailAccountStorageService mass = Services.getService(MailAccountStorageService.class);
                    MailAccount[] accounts = mass.getUserMailAccounts(storageParameters.getUserId(), storageParameters.getContextId());
                    accountList = new ArrayList(accounts.length);
                    for (MailAccount mailAccount : accounts) {
                        if (mailAccount.isDefaultAccount()) continue;
                        accountList.add(mailAccount);
                    }
                    Collections.sort(accountList, new MailAccountComparator(session.getUser().getLocale()));
                    if (!accountList.isEmpty() && UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(((MailAccount)accountList.get(0)).getMailProtocol())) {
                        boolean suppressUnifiedMail = StorageParametersUtility.getBoolParameter("suppressUnifiedMail", storageParameters);
                        UnifiedInboxManagement uim = Services.getService(UnifiedInboxManagement.class);
                        if (suppressUnifiedMail || null == uim || !uim.isEnabled(session.getUserId(), session.getContextId())) {
                            accountList.remove(0);
                        } else {
                            MailAccount unifiedMailAccount = (MailAccount)accountList.remove(0);
                            list.add(0, new MailId(MailFolderUtility.prepareFullname(unifiedMailAccount.getId(), "default"), 0).setName("E-Mail"));
                        }
                    }
                } else {
                    accountList = Collections.emptyList();
                }
                int start = list.size();
                for (int j = 0; j < size; ++j) {
                    MailFolder mf = (MailFolder)folders2.get(j);
                    list.add(new MailId(MailFolderUtility.prepareFullname(mailAccess.getAccountId(), mf.getFullname()), start++).setName(mf.getName()));
                }
                int sz = accountList.size();
                for (int j = 0; j < sz; ++j) {
                    list.add(new MailId(MailFolderUtility.prepareFullname(((MailAccount)accountList.get(j)).getId(), "default"), start++).setName("E-Mail"));
                }
            }
            SortableId[] sortableIdArray = list.toArray(new SortableId[list.size()]);
            return sortableIdArray;
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    @Override
    public SortableId[] getUserSharedFolders(String treeId, ContentType contentType, StorageParameters storageParameters) throws OXException {
        throw new UnsupportedOperationException("MailFolderStorage.getUserSharedFolders()");
    }

    private static void addSubfolders(String fullname, List<MailFolder> folders2, IMailFolderStorage folderStorage) throws OXException {
        MailFolder[] subfolders;
        for (MailFolder subfolder : subfolders = folderStorage.getSubfolders(fullname, false)) {
            folders2.add(subfolder);
            MailFolderStorage.addSubfolders(subfolder.getFullname(), folders2, folderStorage);
        }
    }

    @Override
    public Folder prepareFolder(String treeId, Folder folder, StorageParameters storageParameters) throws OXException {
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
            int accountId = argument.getAccountId();
            String fullname = argument.getFullname();
            if ("default".equals(fullname)) {
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create();
            }
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            if (this.cannotConnect(session)) {
                throw FolderExceptionErrorMessage.MISSING_PARAMETER.create("session.password");
            }
            mailAccess = this.mailAccessFor(session, accountId);
            mailAccess.connect(false);
            if (!mailAccess.getFolderStorage().exists(fullname)) {
                MailFolderStorage.recreateMailFolder(accountId, fullname, session, mailAccess);
            }
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = null;
        try {
            MailProvider provider;
            MailPermission[] mailPermissions;
            FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(folder.getParentID());
            int accountId = arg.getAccountId();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            if (this.cannotConnect(session)) {
                throw FolderExceptionErrorMessage.MISSING_PARAMETER.create("session.password");
            }
            mailAccess = this.mailAccessFor(session, accountId);
            mailAccess.connect(false);
            MailFolderDescription mfd = new MailFolderDescription();
            mfd.setExists(false);
            String parentFullName = arg.getFullname();
            mfd.setParentFullname(parentFullName);
            mfd.setParentAccountId(accountId);
            mfd.setSeparator(mailAccess.getFolderStorage().getFolder(arg.getFullname()).getSeparator());
            String name = folder.getName();
            MailFolderStorage.checkFolderName(name);
            mfd.setName(name);
            mfd.setSubscribed(folder.isSubscribed());
            Permission[] permissions = folder.getPermissions();
            if (null != permissions && permissions.length > 0) {
                mailPermissions = new MailPermission[permissions.length];
                provider = MailProviderRegistry.getMailProviderBySession(session, accountId);
                for (int i = 0; i < permissions.length; ++i) {
                    Permission permission = permissions[i];
                    MailPermission mailPerm = provider.createNewMailPermission(session, accountId);
                    mailPerm.setEntity(permission.getEntity());
                    mailPerm.setAllPermission(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
                    mailPerm.setFolderAdmin(permission.isAdmin());
                    mailPerm.setGroupPermission(permission.isGroup());
                    mailPermissions[i] = mailPerm;
                }
                mfd.addPermissions(mailPermissions);
            } else if ("default".equals(parentFullName)) {
                mailPermissions = new MailPermission[1];
                provider = MailProviderRegistry.getMailProviderBySession(session, accountId);
                MailPermission mailPerm = provider.createNewMailPermission(session, accountId);
                mailPerm.setEntity(session.getUserId());
                mailPerm.setAllPermission(128, 128, 128, 128);
                mailPerm.setFolderAdmin(true);
                mailPerm.setGroupPermission(false);
                mailPermissions[0] = mailPerm;
                mfd.addPermissions(mailPermissions);
            } else {
                MailFolder parent = mailAccess.getFolderStorage().getFolder(parentFullName);
                MailPermission[] parentPermissions = parent.getPermissions();
                ArrayList<MailPermission> mailPermissions2 = new ArrayList<MailPermission>();
                MailProvider provider2 = MailProviderRegistry.getMailProviderBySession(session, accountId);
                for (MailPermission parentPerm : parentPermissions) {
                    MailPermission mailPerm = provider2.createNewMailPermission(session, accountId);
                    mailPerm.setEntity(parentPerm.getEntity());
                    mailPerm.setAllPermission(parentPerm.getFolderPermission(), parentPerm.getReadPermission(), parentPerm.getWritePermission(), parentPerm.getDeletePermission());
                    mailPerm.setFolderAdmin(parentPerm.isFolderAdmin());
                    mailPerm.setGroupPermission(parentPerm.isGroupPermission());
                    mailPermissions2.add(mailPerm);
                }
                mfd.addPermissions(mailPermissions2);
            }
            String fullname = mailAccess.getFolderStorage().createFolder(mfd);
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
            folder.setID(MailFolderUtility.prepareFullname(accountId, fullname));
            String[] folderPath = new String[]{MailFolderUtility.prepareFullname(accountId, fullname), MailFolderUtility.prepareFullname(accountId, parentFullName)};
            MailFolderStorage.postEventRemote(accountId, mfd.getParentFullname(), false, true, folderPath, storageParameters);
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(folderId);
            int accountId = arg.getAccountId();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            if (this.cannotConnect(session)) {
                throw FolderExceptionErrorMessage.MISSING_PARAMETER.create("session.password");
            }
            mailAccess = this.mailAccessFor(session, accountId);
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            mailAccess.connect(null == accessFast ? true : accessFast == false);
            String fullname = arg.getFullname();
            String trashFullname = mailAccess.getFolderStorage().getTrashFolder();
            boolean hardDelete = fullname.startsWith(trashFullname);
            mailAccess.getFolderStorage().clearFolder(fullname, hardDelete);
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
            MailFolderStorage.postEvent(accountId, fullname, true, storageParameters);
            if (!hardDelete) {
                MailFolderStorage.postEvent(accountId, trashFullname, true, storageParameters);
            }
            try {
                MailMessageCache.getInstance().removeFolderMessages(accountId, fullname, storageParameters.getUserId(), storageParameters.getContextId());
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            if (fullname.startsWith(trashFullname)) {
                String subFullname;
                IMailFolderStorageInfoSupport infoSupport;
                boolean doIt = true;
                IMailFolderStorage folderStorage = mailAccess.getFolderStorage();
                if (folderStorage instanceof IMailFolderStorageInfoSupport && (infoSupport = (IMailFolderStorageInfoSupport)folderStorage).isInfoSupported()) {
                    List<MailFolderInfo> subf = infoSupport.getFolderInfos(fullname, false);
                    for (MailFolderInfo mfi : subf) {
                        subFullname = mfi.getFullname();
                        mailAccess.getFolderStorage().deleteFolder(subFullname, true);
                        MailFolderStorage.postEvent(accountId, subFullname, false, true, storageParameters);
                    }
                    MailFolderStorage.postEvent(accountId, trashFullname, false, true, storageParameters);
                    doIt = false;
                }
                if (doIt) {
                    MailFolder[] subf;
                    for (MailFolder element : subf = mailAccess.getFolderStorage().getSubfolders(fullname, true)) {
                        subFullname = element.getFullname();
                        mailAccess.getFolderStorage().deleteFolder(subFullname, true);
                        MailFolderStorage.postEvent(accountId, subFullname, false, true, storageParameters);
                    }
                    MailFolderStorage.postEvent(accountId, trashFullname, false, true, storageParameters);
                }
            }
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = null;
        try {
            String[] stringArray;
            FolderServiceDecorator decorator;
            FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(folderId);
            int accountId = arg.getAccountId();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            if (this.cannotConnect(session)) {
                throw FolderExceptionErrorMessage.MISSING_PARAMETER.create("session.password");
            }
            mailAccess = this.mailAccessFor(session, accountId);
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            mailAccess.connect(null == accessFast ? true : accessFast == false);
            String fullName = arg.getFullname();
            if (this.isDefaultFolder(fullName, mailAccess)) {
                throw MailExceptionCode.NO_DEFAULT_FOLDER_DELETE.create(fullName);
            }
            String trashFullname = mailAccess.getFolderStorage().getTrashFolder();
            String parentFullname = mailAccess.getFolderStorage().getFolder(fullName).getParentFullname();
            boolean hardDelete = fullName.startsWith(trashFullname) ? true : null != (decorator = storageParameters.getDecorator()) && (Boolean.TRUE.equals(decorator.getProperty("hardDelete")) || decorator.getBoolProperty("hardDelete"));
            Map<String, Map<?, ?>> subfolders = MailFolderStorage.subfolders(fullName, mailAccess);
            mailAccess.getFolderStorage().deleteFolder(fullName, hardDelete);
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
            if (null == parentFullname) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = MailFolderUtility.prepareFullname(accountId, fullName);
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = MailFolderUtility.prepareFullname(accountId, fullName);
                stringArray = stringArray3;
                stringArray3[1] = MailFolderUtility.prepareFullname(accountId, parentFullname);
            }
            String[] folderPath = stringArray;
            MailFolderStorage.postEventRemote(accountId, fullName, false, true, false, folderPath, storageParameters);
            try {
                MailMessageCache.getInstance().removeFolderMessages(accountId, fullName, storageParameters.getUserId(), storageParameters.getContextId());
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            if (!hardDelete) {
                folderPath = new String[]{MailFolderUtility.prepareFullname(accountId, trashFullname)};
                MailFolderStorage.postEventRemote(accountId, trashFullname, false, folderPath, storageParameters);
            }
            MailFolderStorage.postEvent4Subfolders(accountId, subfolders, true, storageParameters);
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    @Override
    public String getDefaultFolderID(User user, String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        if (!(contentType instanceof MailContentType)) {
            throw FolderExceptionErrorMessage.UNKNOWN_CONTENT_TYPE.create(contentType.toString());
        }
        if (MailContentType.getInstance().equals(contentType)) {
            return MailFolderUtility.prepareFullname(0, "INBOX");
        }
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = null;
        try {
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            if (this.cannotConnect(session)) {
                throw FolderExceptionErrorMessage.MISSING_PARAMETER.create("session.password");
            }
            mailAccess = this.mailAccessFor(session, 0);
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            mailAccess.connect(null == accessFast ? true : accessFast == false);
            if (DraftsContentType.getInstance().equals(contentType)) {
                String string = MailFolderUtility.prepareFullname(0, mailAccess.getFolderStorage().getDraftsFolder());
                return string;
            }
            if (SentContentType.getInstance().equals(contentType)) {
                String string = MailFolderUtility.prepareFullname(0, mailAccess.getFolderStorage().getSentFolder());
                return string;
            }
            if (SpamContentType.getInstance().equals(contentType)) {
                String string = MailFolderUtility.prepareFullname(0, mailAccess.getFolderStorage().getSpamFolder());
                return string;
            }
            if (TrashContentType.getInstance().equals(contentType)) {
                String string = MailFolderUtility.prepareFullname(0, mailAccess.getFolderStorage().getTrashFolder());
                return string;
            }
            throw FolderExceptionErrorMessage.UNKNOWN_CONTENT_TYPE.create(contentType.toString());
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    @Override
    public Type getTypeByParent(User user, String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        return MailType.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsForeignObjects(User user, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
            int accountId = argument.getAccountId();
            String fullname = argument.getFullname();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            if (this.cannotConnect(session)) {
                boolean bl = false;
                return bl;
            }
            mailAccess = this.mailAccessFor(session, accountId);
            mailAccess.connect(false);
            if (!"default".equals(fullname) && !mailAccess.getFolderStorage().exists(fullname)) {
                throw MailExceptionCode.FOLDER_NOT_FOUND.create(fullname);
            }
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
            boolean bl = false;
            return bl;
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
            int accountId = argument.getAccountId();
            String fullname = argument.getFullname();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            if (this.cannotConnect(session)) {
                boolean bl = true;
                return bl;
            }
            mailAccess = this.mailAccessFor(session, accountId);
            if ("default".equals(fullname)) {
                boolean bl = true;
                return bl;
            }
            mailAccess.connect(false);
            IMailFolderStorage folderStorage = mailAccess.getFolderStorage();
            if (folderStorage instanceof IMailFolderStorageEnhanced) {
                boolean bl = ((IMailFolderStorageEnhanced)folderStorage).getTotalCounter(fullname) > 0;
                return bl;
            }
            boolean bl = 0 == mailAccess.getMessageStorage().searchMessages(fullname, new IndexRange(0, 1), MailSortField.RECEIVED_DATE, OrderDirection.DESC, null, new MailField[]{MailField.ID}).length;
            return bl;
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    @Override
    public void updateLastModified(long lastModified, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageParameters storageParameters) throws OXException {
        return this.getFolders(treeId, folderIds, StorageType.WORKING, storageParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (StorageType.BACKUP.equals(storageType)) {
            throw FolderExceptionErrorMessage.UNSUPPORTED_STORAGE_TYPE.create(storageType);
        }
        TIntObjectHashMap accesses = new TIntObjectHashMap(2);
        try {
            ServerSession session = MailFolderStorage.getServerSession(storageParameters);
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            TIntObjectHashMap accounts = new TIntObjectHashMap(2);
            ArrayList<Folder> ret = new ArrayList<Folder>(folderIds.size());
            ConfigurationService configurationService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            boolean translatePrimaryAccountDefaultFolders = null == configurationService || configurationService.getBoolProperty("com.openexchange.mail.translateDefaultFolders", true);
            for (String folderId : folderIds) {
                MailAccount mailAccount;
                FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
                int accountId = argument.getAccountId();
                MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = (MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage>)accesses.get(accountId);
                if (null == mailAccess) {
                    mailAccess = this.mailAccessFor(session, accountId);
                    accesses.put(accountId, mailAccess);
                }
                if (null == (mailAccount = (MailAccount)accounts.get(argument.getAccountId()))) {
                    MailAccountStorageService storageService = Services.getService(MailAccountStorageService.class);
                    mailAccount = storageService.getMailAccount(accountId, storageParameters.getUserId(), storageParameters.getContextId());
                    accounts.put(accountId, (Object)mailAccount);
                }
                ret.add(this.getFolder(treeId, argument, storageParameters, mailAccess, session, mailAccount, translatePrimaryAccountDefaultFolders));
            }
            ArrayList<Folder> arrayList = ret;
            return arrayList;
        }
        finally {
            accesses.forEachValue(this.procedure);
        }
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.getFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Folder getFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (StorageType.BACKUP.equals(storageType)) {
            throw FolderExceptionErrorMessage.UNSUPPORTED_STORAGE_TYPE.create(storageType);
        }
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
            ServerSession session = MailFolderStorage.getServerSession(storageParameters);
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            MailAccountStorageService storageService = Services.getService(MailAccountStorageService.class);
            MailAccount mailAccount = storageService.getMailAccount(argument.getAccountId(), storageParameters.getUserId(), storageParameters.getContextId());
            mailAccess = this.mailAccessFor(session, argument.getAccountId());
            ConfigurationService configurationService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            boolean translatePrimaryAccountDefaultFolders = null == configurationService || configurationService.getBoolProperty("com.openexchange.mail.translateDefaultFolders", true);
            Folder folder = this.getFolder(treeId, argument, storageParameters, mailAccess, session, mailAccount, translatePrimaryAccountDefaultFolders);
            return folder;
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    private Folder getFolder(String treeId, FullnameArgument argument, StorageParameters storageParameters, MailAccess<?, ?> mailAccess, ServerSession session, MailAccount mailAccount, boolean translateDefaultFolders) throws OXException {
        Folder retval;
        int accountId = argument.getAccountId();
        String fullName = argument.getFullname();
        if (this.cannotConnect(session)) {
            String accountName = "default" + argument.getAccountId();
            return new DummyFolder(treeId, MailFolderUtility.prepareFullname(accountId, argument.getFullname()), accountName, accountName, argument.getFullname(), session.getUserId());
        }
        if ("default".equals(fullName)) {
            if (0 == accountId) {
                mailAccess.connect(false);
                MailFolder rootFolder = mailAccess.getRootFolder();
                retval = new MailFolderImpl(rootFolder, accountId, mailAccess.getMailConfig(), storageParameters, null, mailAccess, mailAccount, translateDefaultFolders);
                MailFolderStorage.addWarnings(mailAccess, storageParameters);
                boolean hasSubfolders = rootFolder.hasSubfolders();
                retval.setSubfolderIDs(hasSubfolders ? null : new String[]{});
            } else {
                retval = IGNORABLES.contains(mailAccount.getMailProtocol()) ? new ExternalMailAccountRootFolder(mailAccount, mailAccess.getMailConfig(), session) : new RemoveAfterAccessExtRootFolder(mailAccount, mailAccess.getMailConfig(), session);
                retval.setSubfolderIDs(null);
            }
        } else {
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            mailAccess.connect(null == accessFast ? true : accessFast == false);
            MailFolder mailFolder = MailFolderStorage.getMailFolder(treeId, accountId, fullName, true, session, mailAccess);
            MailFolderImpl mailFolderImpl = new MailFolderImpl(mailFolder, accountId, mailAccess.getMailConfig(), storageParameters, new MailAccessFullnameProvider(mailAccess), mailAccess, mailAccount, translateDefaultFolders);
            retval = 0 == accountId || IGNORABLES.contains(mailAccount.getMailProtocol()) ? mailFolderImpl : new RemoveAfterAccessFolderWrapper(mailFolderImpl, false, session.getUserId(), session.getContextId());
            boolean hasSubfolders = mailFolder.hasSubfolders();
            if ("INBOX".equals(fullName)) {
                retval.setSubfolderIDs(hasSubfolders ? null : new String[]{});
            } else {
                IMailFolderStorageInfoSupport infoSupport;
                String archiveFullname = MailFolderStorage.optArchiveFullName(mailAccount, mailAccess);
                boolean reverse = null != archiveFullname && archiveFullname.equals(fullName);
                boolean doIt = true;
                Object folderStorage = mailAccess.getFolderStorage();
                if (folderStorage instanceof IMailFolderStorageInfoSupport && (infoSupport = (IMailFolderStorageInfoSupport)folderStorage).isInfoSupported()) {
                    List<MailFolderInfo> folderInfos = infoSupport.getFolderInfos(fullName, false);
                    if (0 == accountId && MailProperties.getInstance().isHidePOP3StorageFolders()) {
                        MailFolderStorage.filterPOP3StorageFolderInfos(folderInfos, session);
                    }
                    boolean translate = !StorageParametersUtility.getBoolParameter("ignoreTranslation", storageParameters);
                    Collections.sort(folderInfos, new SimpleMailFolderInfoComparator(storageParameters.getUser().getLocale(), translate, reverse));
                    String[] subfolderIds = new String[folderInfos.size()];
                    int i = 0;
                    for (MailFolderInfo child : folderInfos) {
                        subfolderIds[i++] = MailFolderUtility.prepareFullname(accountId, child.getFullname());
                    }
                    retval.setSubfolderIDs(subfolderIds);
                    doIt = false;
                }
                if (doIt) {
                    ArrayList<MailFolder> children = new ArrayList<MailFolder>(Arrays.asList(mailAccess.getFolderStorage().getSubfolders(fullName, true)));
                    if (0 == accountId && MailProperties.getInstance().isHidePOP3StorageFolders()) {
                        MailFolderStorage.filterPOP3StorageFolders(children, session);
                    }
                    Collections.sort(children, new SimpleMailFolderComparator(storageParameters.getUser().getLocale(), reverse));
                    String[] subfolderIds = new String[children.size()];
                    int i = 0;
                    for (MailFolder child : children) {
                        subfolderIds[i++] = MailFolderUtility.prepareFullname(accountId, child.getFullname());
                    }
                    retval.setSubfolderIDs(subfolderIds);
                }
            }
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
        }
        retval.setTreeID(treeId);
        return retval;
    }

    private static void filterPOP3StorageFolders(List<MailFolder> folders2, ServerSession session) throws OXException {
        Set<String> pop3StorageFolders = RdbMailAccountStorage.getPOP3StorageFolders(session);
        Iterator<MailFolder> it = folders2.iterator();
        while (it.hasNext()) {
            if (!pop3StorageFolders.contains(it.next().getFullname())) continue;
            it.remove();
        }
    }

    private static void filterPOP3StorageFolderInfos(List<MailFolderInfo> folders2, ServerSession session) throws OXException {
        Set<String> pop3StorageFolders = RdbMailAccountStorage.getPOP3StorageFolders(session);
        Iterator<MailFolderInfo> it = folders2.iterator();
        while (it.hasNext()) {
            if (!pop3StorageFolders.contains(it.next().getFullname())) continue;
            it.remove();
        }
    }

    private static ServerSession getServerSession(StorageParameters storageParameters) throws OXException, OXException {
        Session s = storageParameters.getSession();
        if (null == s) {
            throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
        }
        if (s instanceof ServerSession) {
            return (ServerSession)s;
        }
        return ServerSessionAdapter.valueOf(s);
    }

    private static MailFolder getMailFolder(String treeId, int accountId, String fullname, boolean createIfAbsent, Session session, MailAccess<?, ?> mailAccess) throws OXException {
        OXException exc = null;
        int max = 2;
        int count = 0;
        while (count++ < 2) {
            try {
                return mailAccess.getFolderStorage().getFolder(fullname);
            }
            catch (OXException e) {
                if (count < 2 && MimeMailExceptionCode.STORE_CLOSED.equals(e)) {
                    MailAccess.reconnect(mailAccess);
                    exc = e;
                    continue;
                }
                if (!createIfAbsent) {
                    throw e;
                }
                if (!e.isPrefix("MSG") || MailExceptionCode.FOLDER_NOT_FOUND.getNumber() != e.getCode() || FolderStorage.REAL_TREE_ID.equals(treeId)) {
                    throw e;
                }
                return MailFolderStorage.recreateMailFolder(accountId, fullname, session, mailAccess);
            }
        }
        throw null == exc ? MailExceptionCode.UNEXPECTED_ERROR.create("Connection closed.") : exc;
    }

    private static MailFolder recreateMailFolder(int accountId, String fullname, Session session, MailAccess<?, ?> mailAccess) throws OXException {
        MailFolderDescription mfd = new MailFolderDescription();
        mfd.setExists(false);
        mfd.setAccountId(accountId);
        mfd.setParentAccountId(accountId);
        char separator = mailAccess.getFolderStorage().getFolder("INBOX").getSeparator();
        String[] parentAndName = MailFolderStorage.splitBySeperator(fullname, separator);
        mfd.setParentFullname(parentAndName[0]);
        mfd.setName(parentAndName[1]);
        mfd.setSeparator(separator);
        MailPermission mailPerm = MailProviderRegistry.getMailProviderBySession(session, accountId).createNewMailPermission(session, accountId);
        mailPerm.setEntity(session.getUserId());
        mailPerm.setGroupPermission(false);
        mailPerm.setFolderAdmin(true);
        int max = 128;
        mailPerm.setAllPermission(128, 128, 128, 128);
        mfd.addPermission(mailPerm);
        mfd.setSubscribed(true);
        String id = mailAccess.getFolderStorage().createFolder(mfd);
        return mailAccess.getFolderStorage().getFolder(id);
    }

    private static String[] splitBySeperator(String fullname, char sep) {
        int pos = fullname.lastIndexOf(sep);
        if (pos < 0) {
            return new String[]{"default", fullname};
        }
        return new String[]{fullname.substring(0, pos), fullname.substring(pos + 1)};
    }

    private boolean isDefaultFoldersChecked(int accountId, Session session) {
        Boolean b = (Boolean)MailSessionCache.getInstance(session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderChecked());
        return b != null && b != false;
    }

    private String[] getSortedDefaultMailFolders(int accountId, Session session) {
        String[] arr = (String[])MailSessionCache.getInstance(session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderArray());
        if (arr == null) {
            return new String[0];
        }
        return new String[]{"INBOX", arr[0], arr[1], arr[2], arr[3]};
    }

    @Override
    public FolderType getFolderType() {
        return this.folderType;
    }

    @Override
    public SortableId[] getSubfolders(String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        boolean translate = !StorageParametersUtility.getBoolParameter("ignoreTranslation", storageParameters);
        return this.getSubfolders(parentId, storageParameters, null, translate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortableId[] getSubfolders(String parentId, StorageParameters storageParameters, MailAccess<?, ?> mailAccessArg, boolean translate) throws OXException {
        MailAccess<Object, Object> mailAccess = null;
        boolean closeAccess = true;
        try {
            IMailFolderStorageInfoSupport infoSupport;
            ServerSession session = MailFolderStorage.getServerSession(storageParameters);
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            if (!session.getUserConfiguration().hasWebMail()) {
                SortableId[] sortableIdArray = new SortableId[]{};
                return sortableIdArray;
            }
            FolderServiceDecorator fsDecorator = storageParameters.getDecorator();
            if (fsDecorator != null && !fsDecorator.isContentTypeAllowed(MailContentType.getInstance())) {
                SortableId[] sortableIdArray = new SortableId[]{};
                return sortableIdArray;
            }
            if (this.cannotConnect(session)) {
                SortableId[] sortableIdArray = new SortableId[]{};
                return sortableIdArray;
            }
            if (PRIVATE_FOLDER_ID.equals(parentId)) {
                ArrayList<MailAccount> accounts;
                block65: {
                    MailAccountStorageService storageService;
                    if (session.getUserPermissionBits().isMultipleMailAccounts()) {
                        storageService = Services.getService(MailAccountStorageService.class);
                        MailAccount[] accountsArr = storageService.getUserMailAccounts(session.getUserId(), session.getContextId());
                        ArrayList<MailAccount> tmp = new ArrayList<MailAccount>(accountsArr.length);
                        tmp.addAll(Arrays.asList(accountsArr));
                        Collections.sort(tmp, new MailAccountComparator(session.getUser().getLocale()));
                        accounts = tmp;
                        if (!accounts.isEmpty() && UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(((MailAccount)accounts.get(0)).getMailProtocol())) {
                            boolean suppressUnifiedMail = StorageParametersUtility.getBoolParameter("suppressUnifiedMail", storageParameters);
                            if (suppressUnifiedMail) {
                                accounts.remove(0);
                            } else {
                                UnifiedInboxManagement uim = Services.getService(UnifiedInboxManagement.class);
                                if (null == uim || !uim.isEnabled(session)) {
                                    accounts.remove(0);
                                }
                            }
                        }
                    } else {
                        accounts = new ArrayList<MailAccount>(1);
                        storageService = Services.getService(MailAccountStorageService.class);
                        try {
                            accounts.add(storageService.getDefaultMailAccount(session.getUserId(), session.getContextId()));
                        }
                        catch (OXException e) {
                            if (MailAccountExceptionCodes.NOT_FOUND.equals(e)) break block65;
                            throw e;
                        }
                    }
                }
                int size = accounts.size();
                ArrayList<MailId> list = new ArrayList<MailId>(size);
                for (int j = 0; j < size; ++j) {
                    list.add(new MailId(MailFolderUtility.prepareFullname(((MailAccount)accounts.get(j)).getId(), "default"), j).setName("E-Mail"));
                }
                SortableId[] j = list.toArray(new SortableId[list.size()]);
                return j;
            }
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(parentId);
            int accountId = argument.getAccountId();
            String fullname = argument.getFullname();
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            if (null == mailAccessArg) {
                mailAccess = this.mailAccessFor(session, accountId);
                mailAccess.connect(null == accessFast ? true : accessFast == false);
            } else {
                mailAccess = mailAccessArg;
                if (mailAccess.isConnected()) {
                    closeAccess = false;
                } else {
                    mailAccess.connect(null == accessFast ? true : accessFast == false);
                }
            }
            Object folderStorage = mailAccess.getFolderStorage();
            if (folderStorage instanceof IMailFolderStorageInfoSupport && (infoSupport = (IMailFolderStorageInfoSupport)folderStorage).isInfoSupported()) {
                List<MailFolderInfo> folderInfos = infoSupport.getFolderInfos(fullname, false);
                if (0 == accountId && MailProperties.getInstance().isHidePOP3StorageFolders()) {
                    MailFolderStorage.filterPOP3StorageFolderInfos(folderInfos, session);
                }
                MailFolderStorage.addWarnings(mailAccess, storageParameters);
                if (Boolean.TRUE.equals(accessFast) || !"default".equals(fullname) && !"INBOX".equals(fullname)) {
                    MailAccountStorageService storageService = Services.getService(MailAccountStorageService.class);
                    MailAccount mailAccount = storageService.getMailAccount(accountId, storageParameters.getUserId(), storageParameters.getContextId());
                    String archiveFullName = MailFolderStorage.optArchiveFullName(mailAccount, mailAccess);
                    boolean reverse = null != archiveFullName && archiveFullName.equals(fullname);
                    Collections.sort(folderInfos, new SimpleMailFolderInfoComparator(storageParameters.getUser().getLocale(), translate, reverse));
                } else {
                    String[] names;
                    if (this.isDefaultFoldersChecked(accountId, storageParameters.getSession())) {
                        names = this.getSortedDefaultMailFolders(accountId, storageParameters.getSession());
                    } else {
                        ArrayList<String> tmp = new ArrayList<String>();
                        tmp.add("INBOX");
                        String fn = folderStorage.getDraftsFolder();
                        if (null != fn) {
                            tmp.add(fn);
                        }
                        if (null != (fn = folderStorage.getSentFolder())) {
                            tmp.add(fn);
                        }
                        if (null != (fn = folderStorage.getSpamFolder())) {
                            tmp.add(fn);
                        }
                        if (null != (fn = folderStorage.getTrashFolder())) {
                            tmp.add(fn);
                        }
                        names = tmp.toArray(new String[tmp.size()]);
                    }
                    Locale locale = storageParameters.getUser().getLocale();
                    folderInfos = MailFolderStorage.stripNullElementsFrom(folderInfos);
                    Collections.sort(folderInfos, new MailFolderInfoComparator(names, locale, translate));
                }
                int size = folderInfos.size();
                ArrayList<MailId> list = new ArrayList<MailId>(size);
                for (int j = 0; j < size; ++j) {
                    MailFolderInfo tmp = folderInfos.get(j);
                    list.add(new MailId(MailFolderUtility.prepareFullname(accountId, tmp.getFullname()), j).setName(translate ? tmp.getDisplayName() : tmp.getName()));
                }
                SortableId[] j = list.toArray(new SortableId[list.size()]);
                return j;
            }
            List<MailFolder> children = new ArrayList<MailFolder>(Arrays.asList(mailAccess.getFolderStorage().getSubfolders(fullname, true)));
            if (0 == accountId && MailProperties.getInstance().isHidePOP3StorageFolders()) {
                MailFolderStorage.filterPOP3StorageFolders(children, session);
            }
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
            if (Boolean.TRUE.equals(accessFast) || !"default".equals(fullname) && !"INBOX".equals(fullname)) {
                MailAccountStorageService storageService = Services.getService(MailAccountStorageService.class);
                MailAccount mailAccount = storageService.getMailAccount(accountId, storageParameters.getUserId(), storageParameters.getContextId());
                String archiveFullName = MailFolderStorage.optArchiveFullName(mailAccount, mailAccess);
                boolean reverse = null != archiveFullName && archiveFullName.equals(fullname);
                Collections.sort(children, new SimpleMailFolderComparator(storageParameters.getUser().getLocale(), reverse));
            } else {
                String[] names;
                if (this.isDefaultFoldersChecked(accountId, storageParameters.getSession())) {
                    names = this.getSortedDefaultMailFolders(accountId, storageParameters.getSession());
                } else {
                    ArrayList<String> tmp = new ArrayList<String>();
                    tmp.add("INBOX");
                    Object folderStorage2 = mailAccess.getFolderStorage();
                    String fn = folderStorage2.getDraftsFolder();
                    if (null != fn) {
                        tmp.add(fn);
                    }
                    if (null != (fn = folderStorage2.getSentFolder())) {
                        tmp.add(fn);
                    }
                    if (null != (fn = folderStorage2.getSpamFolder())) {
                        tmp.add(fn);
                    }
                    if (null != (fn = folderStorage2.getTrashFolder())) {
                        tmp.add(fn);
                    }
                    names = tmp.toArray(new String[tmp.size()]);
                }
                Locale locale = storageParameters.getUser().getLocale();
                children = MailFolderStorage.stripNullElementsFrom(children);
                Collections.sort(children, new MailFolderComparator(names, locale));
                if (translate) {
                    block20: for (MailFolder child : children) {
                        Object folderStorage3;
                        if ("INBOX".equals(child.getFullname())) {
                            child.setName(StringHelper.valueOf(locale).getString(MailStrings.INBOX));
                            continue;
                        }
                        if (child.containsDefaultFolderType()) {
                            switch (child.getDefaultFolderType()) {
                                case TRASH: {
                                    child.setName(StringHelper.valueOf(locale).getString(MailStrings.TRASH));
                                    continue block20;
                                }
                                case SENT: {
                                    child.setName(StringHelper.valueOf(locale).getString(MailStrings.SENT));
                                    continue block20;
                                }
                                case SPAM: {
                                    child.setName(StringHelper.valueOf(locale).getString(MailStrings.SPAM));
                                    continue block20;
                                }
                                case DRAFTS: {
                                    child.setName(StringHelper.valueOf(locale).getString(MailStrings.DRAFTS));
                                    continue block20;
                                }
                                case CONFIRMED_SPAM: {
                                    child.setName(StringHelper.valueOf(locale).getString(MailStrings.CONFIRMED_SPAM));
                                    continue block20;
                                }
                                case CONFIRMED_HAM: {
                                    child.setName(StringHelper.valueOf(locale).getString(MailStrings.CONFIRMED_HAM));
                                    continue block20;
                                }
                            }
                            continue;
                        }
                        String fullName = child.getFullname();
                        if (fullName.equals((folderStorage3 = mailAccess.getFolderStorage()).getDraftsFolder())) {
                            child.setName(StringHelper.valueOf(locale).getString(MailStrings.DRAFTS));
                            continue;
                        }
                        if (fullName.equals(folderStorage3.getSentFolder())) {
                            child.setName(StringHelper.valueOf(locale).getString(MailStrings.SENT));
                            continue;
                        }
                        if (fullName.equals(folderStorage3.getSpamFolder())) {
                            child.setName(StringHelper.valueOf(locale).getString(MailStrings.SPAM));
                            continue;
                        }
                        if (fullName.equals(folderStorage3.getTrashFolder())) {
                            child.setName(StringHelper.valueOf(locale).getString(MailStrings.TRASH));
                            continue;
                        }
                        if (fullName.equals(folderStorage3.getConfirmedSpamFolder())) {
                            child.setName(StringHelper.valueOf(locale).getString(MailStrings.CONFIRMED_SPAM));
                            continue;
                        }
                        if (!fullName.equals(folderStorage3.getConfirmedHamFolder())) continue;
                        child.setName(StringHelper.valueOf(locale).getString(MailStrings.CONFIRMED_HAM));
                    }
                }
            }
            int size = children.size();
            ArrayList<MailId> list = new ArrayList<MailId>(size);
            for (int j = 0; j < size; ++j) {
                MailFolder tmp = children.get(j);
                list.add(new MailId(MailFolderUtility.prepareFullname(accountId, tmp.getFullname()), j).setName(tmp.getName()));
            }
            SortableId[] sortableIdArray = list.toArray(new SortableId[list.size()]);
            return sortableIdArray;
        }
        finally {
            if (closeAccess) {
                MailFolderStorage.closeMailAccess(mailAccess);
            }
        }
    }

    @Override
    public void rollback(StorageParameters params) {
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, boolean modify) throws OXException {
        return false;
    }

    @Override
    public StoragePriority getStoragePriority() {
        return StoragePriority.NORMAL;
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.containsFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (StorageType.BACKUP.equals(storageType)) {
            return false;
        }
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
            String fullname = argument.getFullname();
            if ("default".equals(fullname)) {
                boolean bl = true;
                return bl;
            }
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            if (this.cannotConnect(session)) {
                boolean bl = false;
                return bl;
            }
            mailAccess = this.mailAccessFor(session, argument.getAccountId());
            mailAccess.connect(false);
            boolean exists = mailAccess.getFolderStorage().exists(fullname);
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
            boolean bl = exists;
            return bl;
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    @Override
    public String[] getDeletedFolderIDs(String treeId, Date timeStamp, StorageParameters storageParameters) throws OXException {
        return new String[0];
    }

    @Override
    public String[] getModifiedFolderIDs(String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters storageParameters) throws OXException {
        if (null == includeContentTypes || includeContentTypes.length == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        HashSet<ContentType> supported = new HashSet<ContentType>(Arrays.asList(this.getSupportedContentTypes()));
        for (ContentType includeContentType : includeContentTypes) {
            SortableId[] subfolders;
            if (!supported.contains(includeContentType)) continue;
            for (SortableId sortableId : subfolders = this.getSubfolders(treeId, PRIVATE_FOLDER_ID, storageParameters)) {
                ret.add(sortableId.getId());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        String fullname;
        int accountId;
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess;
        block31: {
            MailPermission[] mailPermissions;
            MailFolderDescription mfd;
            block30: {
                String newName;
                String oldName;
                String oldParent;
                char separator;
                int pos;
                mailAccess = null;
                FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder.getID());
                accountId = argument.getAccountId();
                fullname = argument.getFullname();
                Session session = storageParameters.getSession();
                if (null == session) {
                    throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
                }
                if (this.cannotConnect(session)) {
                    throw FolderExceptionErrorMessage.MISSING_PARAMETER.create("session.password");
                }
                mailAccess = this.mailAccessFor(session, accountId);
                mailAccess.connect(false);
                mfd = new MailFolderDescription();
                mfd.setExists(true);
                mfd.setFullname(fullname);
                mfd.setAccountId(accountId);
                if (null != folder.getParentID()) {
                    FullnameArgument parentArg = MailFolderUtility.prepareMailFolderParam(folder.getParentID());
                    mfd.setParentFullname(parentArg.getFullname());
                    mfd.setParentAccountId(parentArg.getAccountId());
                }
                MailFolder mf = mailAccess.getFolderStorage().getFolder(fullname);
                mfd.setSeparator(mf.getSeparator());
                String name = folder.getName();
                if (null != name) {
                    MailFolderStorage.checkFolderName(name);
                    mfd.setName(name);
                }
                if (folder instanceof SetterAwareFolder) {
                    if (((SetterAwareFolder)folder).containsSubscribed()) {
                        mfd.setSubscribed(folder.isSubscribed());
                    }
                } else {
                    mfd.setSubscribed(folder.isSubscribed());
                }
                mailPermissions = null;
                Permission[] permissions = folder.getPermissions();
                if (null != permissions && permissions.length > 0) {
                    mailPermissions = new MailPermission[permissions.length];
                    MailProvider provider = MailProviderRegistry.getMailProviderBySession(session, accountId);
                    for (int i = 0; i < permissions.length; ++i) {
                        Permission permission = permissions[i];
                        MailPermission mailPerm = provider.createNewMailPermission(session, accountId);
                        mailPerm.setEntity(permission.getEntity());
                        mailPerm.setAllPermission(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
                        mailPerm.setFolderAdmin(permission.isAdmin());
                        mailPerm.setGroupPermission(permission.isGroup());
                        mailPermissions[i] = mailPerm;
                    }
                    mfd.addPermissions(mailPermissions);
                }
                if ((pos = fullname.lastIndexOf(separator = mfd.getSeparator())) == -1) {
                    oldParent = "";
                    oldName = fullname;
                } else {
                    oldParent = fullname.substring(0, pos);
                    oldName = fullname.substring(pos + 1);
                }
                boolean movePerformed = false;
                if (mfd.containsParentFullname()) {
                    int parentAccountID = mfd.getParentAccountId();
                    if (accountId == parentAccountID) {
                        String newParent = mfd.getParentFullname();
                        StringBuilder newFullname = new StringBuilder(16);
                        if (!"default".equals(newParent)) {
                            newFullname.append(newParent).append(mfd.getSeparator());
                        }
                        newFullname.append(mfd.containsName() ? mfd.getName() : oldName);
                        if (!newParent.equals(oldParent)) {
                            if (this.isDefaultFolder(fullname, mailAccess)) {
                                throw MailExceptionCode.NO_DEFAULT_FOLDER_UPDATE.create(fullname);
                            }
                            Map<String, Map<?, ?>> subfolders = MailFolderStorage.subfolders(fullname, mailAccess);
                            String oldFullName = fullname;
                            fullname = mailAccess.getFolderStorage().moveFolder(fullname, newFullname.toString());
                            folder.setID(MailFolderUtility.prepareFullname(accountId, fullname));
                            this.postChangedId(fullname, oldFullName, Character.toString(separator), session);
                            MailFolderStorage.postEvent4Subfolders(accountId, subfolders, true, storageParameters);
                            String[] folderPath = new String[]{MailFolderUtility.prepareFullname(accountId, fullname), MailFolderUtility.prepareFullname(accountId, newParent), MailFolderUtility.prepareFullname(accountId, oldParent)};
                            MailFolderStorage.postEventRemote(accountId, newParent, false, folderPath, storageParameters);
                            movePerformed = true;
                        }
                    } else {
                        if (this.isDefaultFolder(fullname, mailAccess)) {
                            throw MailExceptionCode.NO_DEFAULT_FOLDER_UPDATE.create(fullname);
                        }
                        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> otherAccess = null;
                        try {
                            otherAccess = this.mailAccessFor(session, parentAccountID);
                            otherAccess.connect();
                            String newParent = mfd.getParentFullname();
                            MailFolder p = otherAccess.getFolderStorage().getFolder(newParent);
                            MailPermission ownPermission = p.getOwnPermission();
                            if (!ownPermission.canCreateSubfolders()) {
                                throw MailExceptionCode.NO_CREATE_ACCESS.create(newParent);
                            }
                            MailFolder[] tmp = otherAccess.getFolderStorage().getSubfolders(newParent, true);
                            String lookFor = mfd.containsName() ? mfd.getName() : oldName;
                            for (MailFolder sub : tmp) {
                                if (!sub.getName().equals(lookFor)) continue;
                                throw MailExceptionCode.DUPLICATE_FOLDER.create(lookFor);
                            }
                            String destFullname = MailFolderStorage.fullCopy(mailAccess, fullname, otherAccess, newParent, p.getSeparator(), storageParameters.getUserId(), otherAccess.getMailConfig().getCapabilities().hasPermissions());
                            String[] folderPath = new String[]{MailFolderUtility.prepareFullname(parentAccountID, newParent)};
                            MailFolderStorage.postEventRemote(parentAccountID, newParent, false, folderPath, storageParameters);
                            Map<String, Map<?, ?>> subfolders = MailFolderStorage.subfolders(fullname, mailAccess);
                            mailAccess.getFolderStorage().deleteFolder(fullname, true);
                            otherAccess.getFolderStorage().updateFolder(destFullname, mfd);
                            MailFolderStorage.postEvent4Subfolders(accountId, subfolders, true, storageParameters);
                            folder.setID(MailFolderUtility.prepareFullname(parentAccountID, destFullname));
                            otherAccess.getFolderStorage().updateFolder(destFullname, mfd);
                            MailFolderStorage.addWarnings(otherAccess, storageParameters);
                            folderPath = new String[]{MailFolderUtility.prepareFullname(parentAccountID, destFullname)};
                            MailFolderStorage.postEventRemote(parentAccountID, destFullname, false, folderPath, storageParameters);
                            return;
                        }
                        finally {
                            if (null != otherAccess) {
                                otherAccess.close(true);
                            }
                        }
                    }
                }
                if (movePerformed || !mfd.containsName() || (newName = mfd.getName()).equals(oldName)) break block30;
                if (this.isDefaultFolder(fullname, mailAccess)) {
                    throw MailExceptionCode.NO_DEFAULT_FOLDER_RENAME.create(fullname);
                }
                String oldFullName = fullname;
                fullname = mailAccess.getFolderStorage().renameFolder(fullname, newName);
                folder.setID(MailFolderUtility.prepareFullname(accountId, fullname));
                this.postChangedId(fullname, oldFullName, Character.toString(separator), session);
                String[] folderPath = new String[]{MailFolderUtility.prepareFullname(accountId, oldFullName)};
                MailFolderStorage.postEventRemote(accountId, fullname, false, folderPath, storageParameters);
            }
            mailAccess.getFolderStorage().updateFolder(fullname, mfd);
            if (null != mailPermissions && StorageParametersUtility.isHandDownPermissions(storageParameters)) {
                MailFolderStorage.handDown(accountId, fullname, mailPermissions, mailAccess, storageParameters);
            }
            break block31;
            finally {
                MailFolderStorage.closeMailAccess(mailAccess);
            }
        }
        MailFolderStorage.addWarnings(mailAccess, storageParameters);
        String[] folderPath = new String[]{MailFolderUtility.prepareFullname(accountId, fullname)};
        MailFolderStorage.postEventRemote(accountId, fullname, false, folderPath, storageParameters);
    }

    private static void handDown(int accountId, String parentFullName, MailPermission[] mailPermissions, MailAccess<?, ?> mailAccess, StorageParameters params) throws OXException {
        MailFolder[] subfolders;
        for (MailFolder mailFolder : subfolders = mailAccess.getFolderStorage().getSubfolders(parentFullName, true)) {
            MailFolderDescription mfd = new MailFolderDescription();
            mfd.setExists(true);
            String childFullName = mailFolder.getFullname();
            mfd.setFullname(childFullName);
            mfd.setAccountId(accountId);
            mfd.addPermissions(mailPermissions);
            mailAccess.getFolderStorage().updateFolder(childFullName, mfd);
            String[] folderPath = new String[]{MailFolderUtility.prepareFullname(accountId, childFullName)};
            MailFolderStorage.postEventRemote(accountId, childFullName, false, folderPath, params);
            MailFolderStorage.handDown(accountId, childFullName, mailPermissions, mailAccess, params);
        }
    }

    private static String fullCopy(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> srcAccess, String srcFullname, MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> destAccess, String destParent, char destSeparator, int user, boolean hasPermissions) throws OXException {
        MailFolder[] tmp;
        IMailMessageStorageExt storageExt;
        MailFolder source = srcAccess.getFolderStorage().getFolder(srcFullname);
        MailFolderDescription mfd = new MailFolderDescription();
        mfd.setName(source.getName());
        mfd.setParentFullname(destParent);
        mfd.setSeparator(destSeparator);
        mfd.setSubscribed(source.isSubscribed());
        if (hasPermissions) {
            MailPermission[] perms = source.getPermissions();
            try {
                for (MailPermission perm : perms) {
                    mfd.addPermission((MailPermission)perm.clone());
                }
            }
            catch (CloneNotSupportedException e) {
                throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
        String destFullname = destAccess.getFolderStorage().createFolder(mfd);
        IMailMessageStorage srcMessageStorage = srcAccess.getMessageStorage();
        IMailMessageStorage destMessageStorage = destAccess.getMessageStorage();
        MailMessage[] msgs = srcMessageStorage.getAllMessages(srcFullname, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new MailField[]{MailField.ID});
        IMailMessageStorageExt iMailMessageStorageExt = storageExt = srcMessageStorage instanceof IMailMessageStorageExt ? (IMailMessageStorageExt)srcMessageStorage : null;
        if (srcMessageStorage instanceof IMailMessageStorageMimeSupport && destMessageStorage instanceof IMailMessageStorageMimeSupport) {
            int end;
            IMailMessageStorageMimeSupport srcMimeSupport = (IMailMessageStorageMimeSupport)srcMessageStorage;
            IMailMessageStorageMimeSupport dstMimeSupport = (IMailMessageStorageMimeSupport)destMessageStorage;
            int len = msgs.length;
            int limit = 15;
            int offset = 0;
            ArrayList<Message> arr = new ArrayList<Message>(limit);
            do {
                if ((end = offset + limit) > len) {
                    end = len;
                }
                arr.clear();
                for (int i = offset; i < end; ++i) {
                    String mailId = msgs[i].getMailId();
                    arr.add(srcMimeSupport.getMimeMessage(srcFullname, mailId, false));
                }
                dstMimeSupport.appendMimeMessages(destFullname, arr.toArray(new Message[arr.size()]));
                if (null == storageExt) continue;
                storageExt.clearCache();
            } while ((offset = end) < len);
        } else {
            int end;
            int len = msgs.length;
            int limit = 15;
            int offset = 0;
            ArrayList<String> ids = new ArrayList<String>(limit);
            do {
                if ((end = offset + limit) > len) {
                    end = len;
                }
                ids.clear();
                for (int i = offset; i < end; ++i) {
                    ids.add(msgs[i].getMailId());
                }
                MailMessage[] chunk = srcMessageStorage.getMessages(srcFullname, ids.toArray(new String[ids.size()]), new MailField[]{MailField.FULL});
                destMessageStorage.appendMessages(destFullname, chunk);
                if (null == storageExt) continue;
                storageExt.clearCache();
            } while ((offset = end) < len);
        }
        for (MailFolder element : tmp = srcAccess.getFolderStorage().getSubfolders(srcFullname, true)) {
            MailFolderStorage.fullCopy(srcAccess, element.getFullname(), destAccess, destFullname, destSeparator, user, hasPermissions);
        }
        return destFullname;
    }

    private static void postEvent4Subfolders(int accountId, Map<String, Map<?, ?>> subfolders, boolean post, StorageParameters params) {
        int size = subfolders.size();
        Iterator<Map.Entry<String, Map<?, ?>>> iter = subfolders.entrySet().iterator();
        LinkedList<String> ids = new LinkedList<String>();
        String firstKey = null;
        for (int i = 0; i < size; ++i) {
            Map.Entry<String, Map<?, ?>> entry = iter.next();
            Map<String, Map<?, ?>> m = entry.getValue();
            if (!m.isEmpty()) {
                MailFolderStorage.postEvent4Subfolders(accountId, m, false, params);
            }
            if (null == firstKey) {
                firstKey = entry.getKey();
            }
            ids.add(MailFolderUtility.prepareFullname(accountId, entry.getKey()));
        }
        if (post && null != firstKey) {
            MailFolderStorage.postEventRemote(accountId, firstKey, false, true, false, ids.toArray(new String[ids.size()]), params);
        }
    }

    private static Map<String, Map<?, ?>> subfolders(String fullname, MailAccess<?, ?> mailAccess) throws OXException {
        HashMap m = new HashMap();
        MailFolderStorage.subfoldersRecursively(fullname, m, mailAccess);
        return m;
    }

    private static void subfoldersRecursively(String parent, Map<String, Map<?, ?>> m, MailAccess<?, ?> mailAccess) throws OXException {
        MailFolder[] mailFolders = mailAccess.getFolderStorage().getSubfolders(parent, true);
        if (null == mailFolders || 0 == mailFolders.length) {
            Map emptyMap = Collections.emptyMap();
            m.put(parent, emptyMap);
        } else {
            HashMap subMap = new HashMap();
            int size = mailFolders.length;
            for (int i = 0; i < size; ++i) {
                String fullname = mailFolders[i].getFullname();
                MailFolderStorage.subfoldersRecursively(fullname, subMap, mailAccess);
            }
            m.put(parent, subMap);
        }
    }

    private void postChangedId(String newId, String oldId, String delim, Session session) {
        EventAdmin eventAdmin = Services.getService(EventAdmin.class);
        if (null != eventAdmin) {
            HashMap<String, Object> properties = new HashMap<String, Object>(6);
            properties.put("com.openexchange.folderstorage.session", session);
            properties.put("com.openexchange.folderstorage.context", session.getContextId());
            properties.put("com.openexchange.folderstorage.user", session.getUserId());
            properties.put("com.openexchange.folderstorage.oldIdentifier", oldId);
            properties.put("com.openexchange.folderstorage.newIdentifier", newId);
            properties.put("com.openexchange.folderstorage.delimiter", delim);
            properties.put("com.openexchange.folderstorage.immediately", Boolean.TRUE);
            Event event = new Event("com/openexchange/folderstorage/identifiers", properties);
            eventAdmin.postEvent(event);
        }
    }

    private boolean cannotConnect(Session session) throws OXException {
        MailConfig.PasswordSource passwordSource = MailProperties.getInstance().getPasswordSource();
        return passwordSource == MailConfig.PasswordSource.SESSION && session.getPassword() == null;
    }

    private static void postEvent(int accountId, String fullname, boolean contentRelated, StorageParameters params) {
        MailFolderStorage.postEvent(accountId, fullname, contentRelated, false, params);
    }

    private static void postEventRemote(int accountId, String fullname, boolean contentRelated, String[] folderPath, StorageParameters params) {
        MailFolderStorage.postEventRemote(accountId, fullname, contentRelated, false, folderPath, params);
    }

    private static void postEvent(int accountId, String fullname, boolean contentRelated, boolean immediateDelivery, StorageParameters params) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(params.getContextId(), params.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullname), contentRelated, immediateDelivery, false, params.getSession()));
    }

    private static void postEventRemote(int accountId, String fullname, boolean contentRelated, boolean immediateDelivery, String[] folderPath, StorageParameters params) {
        if (0 != accountId) {
            return;
        }
        PooledEvent e = new PooledEvent(params.getContextId(), params.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullname), contentRelated, immediateDelivery, true, params.getSession());
        if (null != folderPath) {
            e.putProperty("com.openexchange.folderstorage.folderPath", folderPath);
        }
        EventPool.getInstance().put(e);
    }

    private static void postEvent(int accountId, String fullname, boolean contentRelated, boolean immediateDelivery, boolean async, StorageParameters params) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(params.getContextId(), params.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullname), contentRelated, immediateDelivery, false, params.getSession()).setAsync(async));
    }

    private static void postEventRemote(int accountId, String fullname, boolean contentRelated, boolean immediateDelivery, boolean async, String[] folderPath, StorageParameters params) {
        if (0 != accountId) {
            return;
        }
        PooledEvent e = new PooledEvent(params.getContextId(), params.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullname), contentRelated, immediateDelivery, true, params.getSession());
        e.setAsync(async);
        if (null != folderPath) {
            e.putProperty("com.openexchange.folderstorage.folderPath", folderPath);
        }
        EventPool.getInstance().put(e);
    }

    protected static void closeMailAccess(MailAccess<?, ?> mailAccess) {
        if (null != mailAccess) {
            try {
                mailAccess.close(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void addWarnings(MailAccess<?, ?> mailAccess, StorageParameters storageParameters) {
        Collection<OXException> warnings = mailAccess.getWarnings();
        if (!warnings.isEmpty()) {
            for (OXException OXException2 : warnings) {
                storageParameters.addWarning(OXException2);
            }
        }
    }

    private static <E> List<E> stripNullElementsFrom(List<E> list) {
        if (null == list || list.isEmpty()) {
            return list;
        }
        ArrayList<E> ret = new ArrayList<E>(list.size());
        for (E element : list) {
            if (null == element) continue;
            ret.add(element);
        }
        return ret;
    }

    private static void checkFolderName(String name) throws OXException {
        if (Strings.isEmpty((String)name)) {
            throw MailExceptionCode.INVALID_FOLDER_NAME_EMPTY.create();
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            if (INVALID.indexOf(name.charAt(i)) < 0) continue;
            throw MailExceptionCode.INVALID_FOLDER_NAME2.create(name, INVALID);
        }
    }

    private static final class MailFolderInfoComparator
    implements Comparator<MailFolderInfo> {
        private final Map<String, Integer> indexMap;
        private final Collator collator;
        private final boolean translate;
        private final Integer na;

        public MailFolderInfoComparator(String[] names, Locale locale, boolean translate) {
            this.translate = translate;
            this.indexMap = new HashMap<String, Integer>(names.length);
            for (int i = 0; i < names.length; ++i) {
                this.indexMap.put(names[i], i);
            }
            this.na = names.length;
            this.collator = Collators.getSecondaryInstance((Locale)locale);
        }

        private Integer getNumberOf(String name) {
            Integer ret = this.indexMap.get(name);
            if (null == ret) {
                return this.na;
            }
            return ret;
        }

        @Override
        public int compare(MailFolderInfo o1, MailFolderInfo o2) {
            if (o1.isDefaultFolder()) {
                if (o2.isDefaultFolder()) {
                    return this.getNumberOf(o1.getFullname()).compareTo(this.getNumberOf(o2.getFullname()));
                }
                return -1;
            }
            if (o2.isDefaultFolder()) {
                return 1;
            }
            return this.collator.compare(this.translate ? o1.getDisplayName() : o1.getName(), this.translate ? o2.getDisplayName() : o2.getName());
        }
    }

    private static final class MailFolderComparator
    implements Comparator<MailFolder> {
        private final Map<String, Integer> indexMap;
        private final Collator collator;
        private final Integer na;

        public MailFolderComparator(String[] names, Locale locale) {
            this.indexMap = new HashMap<String, Integer>(names.length);
            for (int i = 0; i < names.length; ++i) {
                this.indexMap.put(names[i], i);
            }
            this.na = names.length;
            this.collator = Collators.getSecondaryInstance((Locale)locale);
        }

        private Integer getNumberOf(String name) {
            Integer ret = this.indexMap.get(name);
            if (null == ret) {
                return this.na;
            }
            return ret;
        }

        @Override
        public int compare(MailFolder o1, MailFolder o2) {
            if (o1.isDefaultFolder()) {
                if (o2.isDefaultFolder()) {
                    return this.getNumberOf(o1.getFullname()).compareTo(this.getNumberOf(o2.getFullname()));
                }
                return -1;
            }
            if (o2.isDefaultFolder()) {
                return 1;
            }
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private static final class SimpleMailFolderInfoComparator
    implements Comparator<MailFolderInfo> {
        private final Collator collator;
        private final boolean translate;
        private final boolean reverse;

        public SimpleMailFolderInfoComparator(Locale locale, boolean translate) {
            this(locale, translate, false);
        }

        public SimpleMailFolderInfoComparator(Locale locale, boolean translate, boolean reverse) {
            this.reverse = reverse;
            this.translate = translate;
            this.collator = Collators.getSecondaryInstance((Locale)locale);
        }

        @Override
        public int compare(MailFolderInfo o1, MailFolderInfo o2) {
            int result = this.collator.compare(this.translate ? o1.getDisplayName() : o1.getName(), this.translate ? o2.getDisplayName() : o2.getName());
            return this.reverse ? -result : result;
        }
    }

    private static final class SimpleMailFolderComparator
    implements Comparator<MailFolder> {
        private final Collator collator;
        private final boolean reverse;

        public SimpleMailFolderComparator(Locale locale) {
            this(locale, false);
        }

        public SimpleMailFolderComparator(Locale locale, boolean reverse) {
            this.collator = Collators.getSecondaryInstance((Locale)locale);
            this.reverse = reverse;
        }

        @Override
        public int compare(MailFolder o1, MailFolder o2) {
            int result = this.collator.compare(o1.getName(), o2.getName());
            return this.reverse ? -result : result;
        }
    }

    private static final class MailAccountComparator
    implements Comparator<MailAccount> {
        private final Collator collator;

        public MailAccountComparator(Locale locale) {
            this.collator = Collators.getSecondaryInstance((Locale)locale);
        }

        @Override
        public int compare(MailAccount o1, MailAccount o2) {
            if (UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(o1.getMailProtocol())) {
                if (UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(o2.getMailProtocol())) {
                    return 0;
                }
                return -1;
            }
            if (UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(o2.getMailProtocol())) {
                return 1;
            }
            if (o1.isDefaultAccount()) {
                if (o2.isDefaultAccount()) {
                    return 0;
                }
                return -1;
            }
            if (o2.isDefaultAccount()) {
                return 1;
            }
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }
}

