/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.composition.FilenameValidationUtils;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SetterAwareFolder;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParametersUtility;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.filestorage.contentType.FileStorageContentType;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractPerformer;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.folderstorage.internal.performers.ComparedFolderPermissions;
import com.openexchange.folderstorage.internal.performers.ListPerformer;
import com.openexchange.folderstorage.internal.performers.MovePerformer;
import com.openexchange.folderstorage.mail.contentType.MailContentType;
import com.openexchange.folderstorage.osgi.FolderStorageServices;
import com.openexchange.folderstorage.tx.TransactionManager;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.Strings;
import com.openexchange.objectusecount.IncrementArguments;
import com.openexchange.objectusecount.ObjectUseCountService;
import com.openexchange.session.Session;
import com.openexchange.share.recipient.RecipientType;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.LoggerFactory;

public final class UpdatePerformer
extends AbstractUserizedFolderPerformer {
    private static final String CONTENT_TYPE_MAIL = MailContentType.getInstance().toString();

    public UpdatePerformer(ServerSession session, FolderServiceDecorator decorator) throws OXException {
        super(session, decorator);
    }

    public UpdatePerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public UpdatePerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, decorator, folderStorageDiscoverer);
    }

    public UpdatePerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doUpdate(Folder folder, Date timeStamp) throws OXException {
        block74: {
            folderId = folder.getID();
            if (null == folderId) {
                throw FolderExceptionErrorMessage.MISSING_FOLDER_ID.create(new Object[0]);
            }
            treeId = folder.getTreeID();
            if (null == treeId) {
                throw FolderExceptionErrorMessage.MISSING_TREE_ID.create(new Object[0]);
            }
            storage = this.folderStorageDiscoverer.getFolderStorage(treeId, folderId);
            if (null == storage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(new Object[]{treeId, folderId});
            }
            if (null != timeStamp) {
                this.storageParameters.setTimeStamp(timeStamp);
            }
            transactionManager = TransactionManager.initTransaction(this.storageParameters);
            rollbackTransaction = true;
            openedStorages = Collections.emptyList();
            this.checkOpenedStorage(storage, openedStorages);
            try {
                storageFolder = storage.getFolder(treeId, folderId, this.storageParameters);
                oldParentId = storageFolder.getParentID();
                newParentId = folder.getParentID();
                v0 = move = null != newParentId && newParentId.equals(oldParentId) == false;
                if (move) {
                    checkForReservedName = true;
                    if (null == folder.getName()) {
                        folder.setName(storageFolder.getName());
                        checkForReservedName = false;
                    }
                    if (null != this.checkForEqualName(treeId, newParentId, folder, storageFolder.getContentType(), true)) {
                        throw FolderExceptionErrorMessage.EQUAL_NAME.create(new Object[]{folder.getName(), this.getFolderNameSave(storage, newParentId), treeId});
                    }
                    if (checkForReservedName && !folder.getName().equals(storageFolder.getName()) && null != this.checkForReservedName(treeId, newParentId, folder, storageFolder.getContentType(), true)) {
                        throw FolderExceptionErrorMessage.RESERVED_NAME.create(new Object[]{folder.getName()});
                    }
                }
                v1 = rename = null != (newName = folder.getName()) && newName.equals(storageFolder.getName()) == false;
                if (rename && !move) {
                    if (null != this.checkForEqualName(treeId, storageFolder.getParentID(), folder, storageFolder.getContentType(), false)) {
                        throw FolderExceptionErrorMessage.EQUAL_NAME.create(new Object[]{folder.getName(), this.getFolderNameSave(storage, storageFolder.getParentID()), treeId});
                    }
                    if (null != this.checkForReservedName(treeId, storageFolder.getParentID(), folder, storageFolder.getContentType(), false)) {
                        throw FolderExceptionErrorMessage.RESERVED_NAME.create(new Object[]{folder.getName()});
                    }
                    if (InfostoreContentType.getInstance().equals(storageFolder.getContentType()) && Strings.isNotEmpty((String)newName)) {
                        FilenameValidationUtils.checkCharacters((String)newName);
                        FilenameValidationUtils.checkName((String)newName);
                    }
                }
                changeSubscription = false;
                if (folder instanceof SetterAwareFolder) {
                    if (((SetterAwareFolder)folder).containsSubscribed()) {
                        changeSubscription = storageFolder.isSubscribed() != folder.isSubscribed();
                    }
                } else {
                    v2 = changeSubscription = storageFolder.isSubscribed() != folder.isSubscribed();
                }
                changedMetaInfo = null == (meta = folder.getMeta()) ? false : (null == (storageMeta = storageFolder.getMeta()) ? true : false == meta.equals(storageMeta));
                comparedPermissions = new ComparedFolderPermissions((Session)this.session, folder, storageFolder);
                addedDecorator = false;
                decorator = this.storageParameters.getDecorator();
                if (decorator == null) {
                    decorator = new FolderServiceDecorator();
                    this.storageParameters.setDecorator(decorator);
                    addedDecorator = true;
                }
                cascadePermissions = decorator.getBoolProperty("cascadePermissions");
                isRecursion = decorator.containsProperty(UpdatePerformer.RECURSION_MARKER);
                if (!isRecursion) {
                    decorator.put(UpdatePerformer.RECURSION_MARKER, true);
                }
                try {
                    block75: {
                        block76: {
                            if (move) {
                                newParentId = folder.getParentID();
                                newRealParentStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, newParentId);
                                if (null == newRealParentStorage) {
                                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(new Object[]{FolderStorage.REAL_TREE_ID, newParentId});
                                }
                                realParentStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, oldParentId);
                                if (null == realParentStorage) {
                                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(new Object[]{FolderStorage.REAL_TREE_ID, oldParentId});
                                }
                                realStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, folder.getID());
                                if (null == realStorage) {
                                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(new Object[]{FolderStorage.REAL_TREE_ID, folder.getID()});
                                }
                                if (FileStorageContentType.getInstance().equals(realParentStorage.getDefaultContentType())) {
                                    newRealParentStorage = realParentStorage;
                                    realStorage = realParentStorage;
                                } else if (FileStorageContentType.getInstance().equals(newRealParentStorage.getDefaultContentType())) {
                                    realParentStorage = newRealParentStorage;
                                    realStorage = newRealParentStorage;
                                }
                                if (this.equallyNamedSibling(folder.getName(), treeId, newParentId, openedStorages)) {
                                    throw FolderExceptionErrorMessage.EQUAL_NAME.create(new Object[]{folder.getName(), this.getFolderNameSave(newRealParentStorage, newParentId), treeId});
                                }
                                if (UpdatePerformer.CONTENT_TYPE_MAIL.equals(storageFolder.getContentType().toString())) {
                                    started = newRealParentStorage.startTransaction(this.storageParameters, true);
                                    rollback = true;
                                    try {
                                        newParent = newRealParentStorage.getFolder(FolderStorage.REAL_TREE_ID, newParentId, this.storageParameters);
                                        if (UpdatePerformer.isPublicPimFolder(newParent)) {
                                            throw FolderExceptionErrorMessage.NO_PUBLIC_MAIL_FOLDER.create();
                                        }
                                        if (started) {
                                            newRealParentStorage.commitTransaction(this.storageParameters);
                                            rollback = false;
                                        }
                                    }
                                    catch (RuntimeException e) {
                                        throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, new Object[]{e.getMessage()});
                                    }
                                    finally {
                                        if (started && rollback) {
                                            newRealParentStorage.rollback(this.storageParameters);
                                        }
                                    }
                                }
                                movePerformer = this.newMovePerformer();
                                movePerformer.setStorageParameters(this.storageParameters);
                                if (FolderStorage.REAL_TREE_ID.equals(folder.getTreeID())) {
                                    movePerformer.doMoveReal(folder, storage, realParentStorage, newRealParentStorage);
                                } else {
                                    movePerformer.doMoveVirtual(folder, storage, realStorage, realParentStorage, newRealParentStorage, storageFolder, openedStorages);
                                }
                                break block74;
                            }
                            if (rename) {
                                folder.setParentID(oldParentId);
                                if (this.equallyNamedSibling(folder.getName(), treeId, oldParentId, openedStorages)) {
                                    throw FolderExceptionErrorMessage.EQUAL_NAME.create(new Object[]{folder.getName(), oldParentId, treeId});
                                }
                                if (FolderStorage.REAL_TREE_ID.equals(folder.getTreeID())) {
                                    this.doRenameReal(folder, storage);
                                } else {
                                    this.doRenameVirtual(folder, storage, openedStorages);
                                }
                                break block74;
                            }
                            if (!comparedPermissions.hasChanges() && !cascadePermissions) break block75;
                            useCountService = FolderStorageServices.requireService(ObjectUseCountService.class);
                            addedUsers = comparedPermissions.getAddedUsers();
                            if (null != useCountService && null != addedUsers && !addedUsers.isEmpty()) {
                                for (Integer i : addedUsers) {
                                    arguments = new IncrementArguments.Builder(i.intValue()).build();
                                    useCountService.incrementObjectUseCount((Session)this.session, arguments);
                                }
                            }
                            this.checkGuestPermissions(storageFolder, comparedPermissions);
                            if (!isRecursion && comparedPermissions.hasNewGuests()) {
                                this.processAddedGuestPermissions(folderId, storageFolder.getContentType(), comparedPermissions, transactionManager.getConnection());
                            }
                            if (cascadePermissions) {
                                decorator.put("cascadePermissions", Boolean.FALSE);
                            }
                            if (FolderStorage.REAL_TREE_ID.equals(folder.getTreeID())) {
                                storage.updateFolder(folder, this.storageParameters);
                            } else {
                                realStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, folder.getID());
                                if (null == realStorage) {
                                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(new Object[]{FolderStorage.REAL_TREE_ID, folder.getID()});
                                }
                                if (storage.equals(realStorage)) {
                                    storage.updateFolder(folder, this.storageParameters);
                                } else {
                                    this.checkOpenedStorage(realStorage, openedStorages);
                                    realStorage.updateFolder(folder, this.storageParameters);
                                    storage.updateFolder(folder, this.storageParameters);
                                }
                            }
                            if (!cascadePermissions) break block76;
                            ignoreWarnings = StorageParametersUtility.getBoolParameter("ignoreWarnings", this.storageParameters);
                            this.checkOpenedStorage(storage, openedStorages);
                            subfolderIDs = new ArrayList<String>();
                            try {
                                this.gatherSubfolders(folder, storage, treeId, subfolderIDs, ignoreWarnings);
                                if (0 < subfolderIDs.size()) {
                                    permissions = new ArrayList<Permission>(folder.getPermissions().length);
                                    for (Permission permission : folder.getPermissions()) {
                                        if (!permission.isGroup() && null != (guest = comparedPermissions.getGuestInfo(permission.getEntity())) && RecipientType.ANONYMOUS.equals((Object)guest.getRecipientType())) continue;
                                        permissions.add(permission);
                                    }
                                    this.updatePermissions(storage, treeId, subfolderIDs, permissions.toArray(new Permission[permissions.size()]));
                                }
                                ** break block77
                            }
                            catch (OXException e) {
                                if (OXFolderExceptionCode.NO_ADMIN_ACCESS.equals(e)) {
                                    this.addWarning(e);
                                    if (!isRecursion) {
                                        decorator.remove(UpdatePerformer.RECURSION_MARKER);
                                    }
                                    if (addedDecorator) {
                                        this.storageParameters.setDecorator(null);
                                    }
                                    if (rollbackTransaction) {
                                        transactionManager.rollback();
                                    }
                                    return;
                                }
                                throw e;
                            }
                        }
lbl-1000:
                        // 1 sources

                        {
                        }
                    }
                    {
                        catch (Throwable var30_44) {
                            throw var30_44;
                        }
                    }
                }
                finally {
                    if (!isRecursion) {
                        decorator.remove(UpdatePerformer.RECURSION_MARKER);
                    }
                    if (addedDecorator) {
                        this.storageParameters.setDecorator(null);
                    }
                }
            }
            catch (OXException e) {
                throw e;
            }
            catch (Exception e) {
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, new Object[]{e.getMessage()});
            }
            finally {
                if (rollbackTransaction) {
                    transactionManager.rollback();
                }
            }
        }
        transactionManager.commit();
        rollbackTransaction = false;
        warnings = this.storageParameters.getWarnings();
        if (null != warnings) {
            for (OXException warning : warnings) {
                this.addWarning(warning);
            }
        }
    }

    private void gatherSubfolders(Folder folder, FolderStorage storage, String treeId, List<String> ids, boolean ignoreWarnings) throws OXException {
        SortableId[] sortableIds;
        for (SortableId id : sortableIds = storage.getSubfolders(treeId, folder.getID(), this.storageParameters)) {
            Folder f = storage.getFolder(treeId, id.getId(), this.storageParameters);
            Permission permission = CalculatePermission.calculate(f, this, (List<ContentType>)ALL_ALLOWED);
            if (!permission.isAdmin()) {
                int userId;
                int contextId;
                if (ignoreWarnings) continue;
                if (this.session == null) {
                    contextId = this.context.getContextId();
                    userId = this.user.getId();
                } else {
                    contextId = this.session.getContextId();
                    userId = this.session.getUserId();
                }
                throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(userId, f.getName(), contextId);
            }
            ids.add(f.getID());
            this.gatherSubfolders(f, storage, treeId, ids, ignoreWarnings);
        }
    }

    private void updatePermissions(FolderStorage storage, String treeId, List<String> folderIDs, Permission[] permissions) throws OXException {
        for (String id : folderIDs) {
            AbstractPerformer.UpdateFolder toUpdate = new AbstractPerformer.UpdateFolder();
            toUpdate.setTreeID(treeId);
            toUpdate.setID(id);
            toUpdate.setPermissions(permissions);
            storage.updateFolder(toUpdate, this.storageParameters);
        }
    }

    private MovePerformer newMovePerformer() throws OXException {
        if (null == this.session) {
            return new MovePerformer(this.user, this.context, this.folderStorageDiscoverer);
        }
        return new MovePerformer(this.session, this.folderStorageDiscoverer);
    }

    private void doRenameReal(Folder folder, FolderStorage realStorage) throws OXException {
        realStorage.updateFolder(folder, this.storageParameters);
    }

    private void doRenameVirtual(Folder folder, FolderStorage virtualStorage, List<FolderStorage> openedStorages) throws OXException {
        FolderStorage realStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, folder.getID());
        if (null == realStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(FolderStorage.REAL_TREE_ID, folder.getID());
        }
        if (virtualStorage.equals(realStorage)) {
            virtualStorage.updateFolder(folder, this.storageParameters);
        } else {
            this.checkOpenedStorage(realStorage, openedStorages);
            Folder realFolder = realStorage.getFolder(FolderStorage.REAL_TREE_ID, folder.getID(), this.storageParameters);
            Folder clone4Real = (Folder)folder.clone();
            clone4Real.setParentID(null);
            clone4Real.setName(this.nonExistingName(clone4Real.getName(), FolderStorage.REAL_TREE_ID, realFolder.getParentID(), openedStorages));
            realStorage.updateFolder(clone4Real, this.storageParameters);
            folder.setNewID(clone4Real.getID());
            virtualStorage.updateFolder(folder, this.storageParameters);
            folder.setID(clone4Real.getID());
        }
    }

    private void checkOpenedStorage(FolderStorage storage, List<FolderStorage> openedStorages) throws OXException {
        for (FolderStorage openedStorage : openedStorages) {
            if (!openedStorage.equals(storage)) continue;
            return;
        }
        if (storage.startTransaction(this.storageParameters, true)) {
            openedStorages.add(storage);
        }
    }

    private boolean equallyNamedSibling(String name, String treeId, String parentId, Collection<FolderStorage> openedStorages) throws OXException {
        UserizedFolder[] subfolders;
        ListPerformer listPerformer = null == this.session ? new ListPerformer(this.user, this.context, null) : new ListPerformer(this.session, null);
        listPerformer.setStorageParameters(this.storageParameters);
        for (UserizedFolder userizedFolder : subfolders = listPerformer.doList(treeId, parentId, true, openedStorages, false)) {
            if (!name.equals(userizedFolder.getName())) continue;
            return true;
        }
        return false;
    }

    private String nonExistingName(String name, String treeId, String parentId, Collection<FolderStorage> openedStorages) throws OXException {
        ListPerformer listPerformer = null == this.session ? new ListPerformer(this.user, this.context, null) : new ListPerformer(this.session, null);
        listPerformer.setStorageParameters(this.storageParameters);
        UserizedFolder[] subfolders = listPerformer.doList(treeId, parentId, true, openedStorages, false);
        StringBuilder sb = new StringBuilder();
        String nonExistingName = name;
        int i = 0;
        int count = 0;
        while (i < subfolders.length) {
            if (nonExistingName.equals(subfolders[i].getName())) {
                sb.setLength(0);
                sb.append(name).append('_').append(String.valueOf(++count));
                nonExistingName = sb.toString();
                i = 0;
                continue;
            }
            ++i;
        }
        return nonExistingName;
    }

    private String getFolderNameSave(FolderStorage storage, String folderId) {
        try {
            Folder folder = storage.getFolder(FolderStorage.REAL_TREE_ID, folderId, this.storageParameters);
            return folder.getName();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(UpdatePerformer.class).debug("Error getting name for folder '{}'", (Object)folderId, (Object)e);
            return folderId;
        }
    }
}

