/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal;

import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageComparator;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.internal.ContentTypeRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public final class FolderStorageRegistry
implements FolderStorageDiscoverer {
    private static final FolderStorageRegistry instance = new FolderStorageRegistry();
    private final ConcurrentMap<String, Queue<FolderStorage>> registry = new ConcurrentHashMap<String, Queue<FolderStorage>>();
    private volatile Queue<FolderStorage> genStorages = new ConcurrentLinkedQueue<FolderStorage>();

    public static FolderStorageRegistry getInstance() {
        return instance;
    }

    private FolderStorageRegistry() {
    }

    public boolean addFolderStorage(String treeId, FolderStorage folderStorage) {
        ContentType[] contentTypes = folderStorage.getSupportedContentTypes();
        if (null != contentTypes && contentTypes.length > 0) {
            boolean success = true;
            for (int i = 0; success && i < contentTypes.length; ++i) {
                success = ContentTypeRegistry.getInstance().addContentType(treeId, contentTypes[i], folderStorage);
            }
            if (!success) {
                for (ContentType contentType : contentTypes) {
                    ContentTypeRegistry.getInstance().removeContentType(treeId, contentType);
                }
                return false;
            }
        } else if (!ContentTypeRegistry.getInstance().addGeneralContentType(treeId, folderStorage)) {
            return false;
        }
        if (FolderStorage.ALL_TREE_ID.equals(treeId)) {
            ArrayList<FolderStorage> tmp = new ArrayList<FolderStorage>(this.genStorages);
            tmp.add(folderStorage);
            Collections.sort(tmp, FolderStorageComparator.getInstance());
            this.genStorages = new ConcurrentLinkedQueue<FolderStorage>(tmp);
        } else {
            ConcurrentLinkedQueue<FolderStorage> tmp;
            ConcurrentLinkedQueue<FolderStorage> storages = (ConcurrentLinkedQueue<FolderStorage>)this.registry.get(treeId);
            if (null == storages && null == (storages = (Queue)this.registry.putIfAbsent(treeId, tmp = new ConcurrentLinkedQueue<FolderStorage>()))) {
                storages = tmp;
            }
            storages.add(folderStorage);
        }
        return true;
    }

    @Override
    public FolderStorage getFolderStorage(String treeId, String folderId) {
        Queue storages;
        Queue<FolderStorage> genericStorages = this.genStorages;
        if (!genericStorages.isEmpty()) {
            for (FolderStorage folderStorage : genericStorages) {
                FolderType folderType = folderStorage.getFolderType();
                if (!folderType.servesTreeId(treeId) || !folderType.servesFolderId(folderId)) continue;
                return folderStorage;
            }
        }
        if (null == (storages = (Queue)this.registry.get(treeId))) {
            return null;
        }
        for (FolderStorage folderStorage : storages) {
            if (!folderStorage.getFolderType().servesFolderId(folderId)) continue;
            return folderStorage;
        }
        return null;
    }

    @Override
    public FolderStorage[] getFolderStoragesForParent(String treeId, String parentId) {
        Queue storages;
        Queue<FolderStorage> genericStorages = this.genStorages;
        if (!genericStorages.isEmpty()) {
            for (FolderStorage folderStorage : genericStorages) {
                FolderType folderType = folderStorage.getFolderType();
                if (!folderType.servesTreeId(treeId) || !folderType.servesParentId(parentId)) continue;
                return new FolderStorage[]{folderStorage};
            }
        }
        if (null == (storages = (Queue)this.registry.get(treeId))) {
            return new FolderStorage[0];
        }
        ArrayList<FolderStorage> l = new ArrayList<FolderStorage>(4);
        for (FolderStorage folderStorage : storages) {
            if (!folderStorage.getFolderType().servesParentId(parentId)) continue;
            l.add(folderStorage);
        }
        return l.toArray(new FolderStorage[l.size()]);
    }

    @Override
    public FolderStorage[] getFolderStoragesForTreeID(String treeId) {
        Queue storages;
        Queue<FolderStorage> genericStorages = this.genStorages;
        if (!genericStorages.isEmpty()) {
            for (FolderStorage folderStorage : genericStorages) {
                FolderType folderType = folderStorage.getFolderType();
                if (!folderType.servesTreeId(treeId)) continue;
                return new FolderStorage[]{folderStorage};
            }
        }
        if (null == (storages = (Queue)this.registry.get(treeId))) {
            return new FolderStorage[0];
        }
        return storages.toArray(new FolderStorage[storages.size()]);
    }

    @Override
    public FolderStorage[] getTreeFolderStorages(String treeId) {
        Queue storages;
        Queue<FolderStorage> genericStorages = this.genStorages;
        if (!genericStorages.isEmpty()) {
            for (FolderStorage folderStorage : genericStorages) {
                if (StoragePriority.HIGHEST.equals(folderStorage.getStoragePriority()) || !folderStorage.getFolderType().servesTreeId(treeId)) continue;
                return new FolderStorage[]{folderStorage};
            }
        }
        if (null == (storages = (Queue)this.registry.get(treeId))) {
            return new FolderStorage[0];
        }
        return storages.toArray(new FolderStorage[storages.size()]);
    }

    @Override
    public FolderStorage getFolderStorageByContentType(String treeId, ContentType contentType) {
        return ContentTypeRegistry.getInstance().getFolderStorageByContentType(treeId, contentType);
    }

    public void removeFolderStorage(String treeId, FolderStorage folderStorage) {
        if (FolderStorage.ALL_TREE_ID.equals(treeId)) {
            this.genStorages.remove(folderStorage);
        } else {
            Queue storages = (Queue)this.registry.get(treeId);
            if (null == storages) {
                return;
            }
            storages.remove(folderStorage);
        }
        ContentType[] contentTypes = folderStorage.getSupportedContentTypes();
        if (null != contentTypes && contentTypes.length > 0) {
            for (ContentType contentType : contentTypes) {
                ContentTypeRegistry.getInstance().removeContentType(treeId, contentType);
            }
        } else {
            ContentTypeRegistry.getInstance().removeGeneralContentType(treeId, folderStorage);
        }
    }
}

