/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderI18nNamesService;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.modules.Module;
import com.openexchange.i18n.I18nService;
import com.openexchange.java.Strings;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.arrays.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class FolderI18nNamesServiceImpl
implements FolderI18nNamesService {
    private static final FolderI18nNamesServiceImpl INSTANCE = new FolderI18nNamesServiceImpl();
    private final Map<Locale, I18nService> services = new ConcurrentHashMap<Locale, I18nService>();
    private final Map<Integer, Set<String>> identifiersPerModule = new ConcurrentHashMap<Integer, Set<String>>();
    private final Map<Integer, Set<String>> i18nNamesPerModule = new ConcurrentHashMap<Integer, Set<String>>();

    public static FolderI18nNamesServiceImpl getInstance() {
        return INSTANCE;
    }

    private FolderI18nNamesServiceImpl() {
        this.initIdentifiers();
    }

    private void initIdentifiers() {
        HashSet<String> identifiers = new HashSet<String>();
        identifiers.add(MailStrings.INBOX);
        identifiers.add(MailStrings.SPAM);
        identifiers.add(MailStrings.DRAFTS);
        identifiers.add(MailStrings.TRASH);
        identifiers.add(MailStrings.SENT);
        identifiers.add(MailStrings.SENT_ALT);
        identifiers.add(MailStrings.CONFIRMED_HAM);
        identifiers.add(MailStrings.CONFIRMED_HAM_ALT);
        identifiers.add(MailStrings.CONFIRMED_SPAM);
        identifiers.add(MailStrings.CONFIRMED_SPAM_ALT);
        this.identifiersPerModule.put(Module.MAIL.getFolderConstant(), identifiers);
        identifiers = new HashSet();
        identifiers.add("Calendar");
        identifiers.add("Other calendar folders");
        this.identifiersPerModule.put(Module.CALENDAR.getFolderConstant(), identifiers);
        identifiers = new HashSet();
        identifiers.add("Collected addresses");
        identifiers.add("Contacts");
        identifiers.add("Shared address book");
        identifiers.add("Global address book");
        identifiers.add("Other contact folders");
        this.identifiersPerModule.put(Module.CONTACTS.getFolderConstant(), identifiers);
        identifiers = new HashSet();
        identifiers.add("Tasks");
        identifiers.add("Other task folders");
        this.identifiersPerModule.put(Module.TASK.getFolderConstant(), identifiers);
        identifiers = new HashSet();
        identifiers.add("E-Mail attachments");
        identifiers.add("Infostore");
        identifiers.add("Public infostore");
        identifiers.add("Trash");
        identifiers.add("Userstore");
        identifiers.add("Other infostore folders");
        identifiers.add("Drive");
        identifiers.add("Shared files");
        identifiers.add("Public files");
        identifiers.add("Trash");
        identifiers.add("Other files");
        identifiers.add("Pictures");
        identifiers.add("Documents");
        identifiers.add("Music");
        identifiers.add("Videos");
        identifiers.add("Templates");
        this.identifiersPerModule.put(Module.INFOSTORE.getFolderConstant(), identifiers);
        identifiers = new HashSet();
        identifiers.add("System");
        identifiers.add("OX folders");
        identifiers.add("Private folders");
        identifiers.add("Public folders");
        identifiers.add("Shared folders");
        this.identifiersPerModule.put(Module.SYSTEM.getFolderConstant(), identifiers);
    }

    public void addService(I18nService service) {
        this.services.put(service.getLocale(), service);
        this.i18nNamesPerModule.clear();
    }

    public void removeService(I18nService service) {
        this.services.remove(service.getLocale());
        this.i18nNamesPerModule.clear();
    }

    @Override
    public Set<String> getI18nNamesFor(int ... modules) {
        Map<Integer, Set<String>> i18nNamesPerModule = this.getI18nNamesPerModule();
        HashSet<String> i18nNames = new HashSet<String>();
        if (null == modules || 0 == modules.length) {
            for (Set<String> names : i18nNamesPerModule.values()) {
                i18nNames.addAll(names);
            }
        } else {
            for (Map.Entry<Integer, Set<String>> entry : i18nNamesPerModule.entrySet()) {
                if (!Arrays.contains((int[])modules, (int)entry.getKey())) continue;
                i18nNames.addAll((Collection)entry.getValue());
            }
        }
        return Collections.unmodifiableSet(i18nNames);
    }

    @Override
    public Set<String> getI18nNamesFor(int module, String ... folderStrings) throws OXException {
        Set<String> knownIdentifiers = this.identifiersPerModule.get(module);
        if (null == knownIdentifiers || 0 == knownIdentifiers.size()) {
            return Collections.emptySet();
        }
        HashSet<String> i18nNames = new HashSet<String>();
        for (String folderString : folderStrings) {
            if (!knownIdentifiers.contains(folderString)) continue;
            i18nNames.add(folderString);
            for (I18nService service : this.services.values()) {
                i18nNames.add(service.getLocalized(folderString));
            }
        }
        return i18nNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Set<String>> getI18nNamesPerModule() {
        if (this.i18nNamesPerModule.isEmpty()) {
            Map<Locale, I18nService> map = this.services;
            synchronized (map) {
                if (this.i18nNamesPerModule.isEmpty()) {
                    Set<String> reservedNames = FolderI18nNamesServiceImpl.getFolderReservedNames();
                    for (Map.Entry<Integer, Set<String>> entry : this.identifiersPerModule.entrySet()) {
                        HashSet<String> i18nNames = new HashSet<String>();
                        i18nNames.addAll(reservedNames);
                        i18nNames.addAll((Collection)entry.getValue());
                        for (I18nService service : this.services.values()) {
                            for (String identifier : entry.getValue()) {
                                i18nNames.add(service.getLocalized(identifier));
                            }
                        }
                        this.i18nNamesPerModule.put(entry.getKey(), i18nNames);
                    }
                }
            }
        }
        return this.i18nNamesPerModule;
    }

    private static Set<String> getFolderReservedNames() {
        String text;
        HashSet<String> reservedNames = new HashSet<String>();
        ConfigurationService configService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null != configService && !Strings.isEmpty((String)(text = configService.getText("folder-reserved-names")))) {
            for (String line : text.split("\r?\n")) {
                if (Strings.isEmpty((String)line) || '#' == line.charAt(0)) continue;
                for (String value : line.split(" *, *")) {
                    String processedValue = FolderI18nNamesServiceImpl.processValue(value);
                    if (null == processedValue) continue;
                    reservedNames.add(processedValue);
                }
            }
        }
        return reservedNames;
    }

    private static String processValue(String value) {
        if (Strings.isEmpty((String)value)) {
            return null;
        }
        String val = value.trim();
        if ('#' == val.charAt(0)) {
            return null;
        }
        int mlen = val.length() - 1;
        if ('\"' == val.charAt(0) && '\"' == val.charAt(mlen)) {
            if (0 == mlen) {
                return null;
            }
            if (Strings.isEmpty((String)(val = val.substring(1, mlen)))) {
                return null;
            }
        }
        return val;
    }
}

