/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database.getfolder;

import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.database.AltNameLocalizedDatabaseFolder;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.PutIfAbsent;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import gnu.trove.list.TIntList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemInfostoreFolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemInfostoreFolder.class);

    private SystemInfostoreFolder() {
    }

    public static DatabaseFolder getSystemInfostoreFolder(FolderObject fo, boolean altNames) {
        AltNameLocalizedDatabaseFolder retval = new AltNameLocalizedDatabaseFolder(fo, "Drive");
        retval.setName(altNames ? "Drive" : "Infostore");
        retval.setContentType(InfostoreContentType.getInstance());
        retval.setSubfolderIDs(null);
        retval.setSubscribedSubfolders(true);
        if (altNames) {
            retval.setCacheable(false);
        }
        return retval;
    }

    public static List<String[]> getSystemInfostoreFolderSubfolders(User user, UserPermissionBits permissionBits, Context context, boolean altNames, Session session, Connection connection) throws OXException {
        StringHelper stringHelper = StringHelper.valueOf(user.getLocale());
        ArrayList<String[]> subfolderIDs = new ArrayList<String[]>();
        SearchIterator<FolderObject> searchIterator = null;
        try {
            searchIterator = OXFolderIteratorSQL.getVisibleSubfoldersIterator(9, user.getId(), user.getGroups(), context, permissionBits, null, connection);
            while (searchIterator.hasNext()) {
                String name;
                FolderObject folder = (FolderObject)searchIterator.next();
                if (10 == folder.getObjectID()) {
                    if (SystemInfostoreFolder.showPersonalBelowInfoStore(session, altNames)) {
                        TIntList visibleSubfolderIDs = OXFolderIteratorSQL.getVisibleSubfolders(folder.getObjectID(), user.getId(), user.getGroups(), permissionBits.getAccessibleModules(), context, connection);
                        if (1 >= visibleSubfolderIDs.size() && (1 != visibleSubfolderIDs.size() || visibleSubfolderIDs.remove(SystemInfostoreFolder.getDefaultInfoStoreFolderId(session, context, connection))) && 0L >= new OXFolderAccess(connection, context).getItemCount(folder, session, context)) continue;
                        subfolderIDs.add(0, new String[]{String.valueOf(folder.getObjectID()), stringHelper.getString("Shared files")});
                        continue;
                    }
                    name = stringHelper.getString(altNames ? "Shared files" : "Userstore");
                    subfolderIDs.add(0, new String[]{String.valueOf(folder.getObjectID()), name});
                    continue;
                }
                if (15 == folder.getObjectID()) {
                    if ((!permissionBits.hasFullPublicFolderAccess() || !folder.getEffectiveUserPermission(user.getId(), permissionBits, connection).canCreateSubfolders()) && 0 >= OXFolderIteratorSQL.getVisibleSubfolders(folder.getObjectID(), user.getId(), user.getGroups(), permissionBits.getAccessibleModules(), context, connection).size()) continue;
                    name = stringHelper.getString(altNames ? "Public files" : "Public infostore");
                    subfolderIDs.add(new String[]{String.valueOf(folder.getObjectID()), name});
                    continue;
                }
                if (16 == folder.getType() && folder.isDefaultFolder()) {
                    name = stringHelper.getString(altNames ? "Trash" : "Trash");
                    subfolderIDs.add(new String[]{String.valueOf(folder.getObjectID()), name});
                    continue;
                }
                subfolderIDs.add(new String[]{String.valueOf(folder.getObjectID()), folder.getFolderName()});
            }
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            SearchIterators.close(searchIterator);
        }
        if (OXFolderIteratorSQL.hasVisibleFoldersNotSeenInTreeView(8, user.getId(), user.getGroups(), permissionBits, context, connection)) {
            String name = stringHelper.getString(altNames ? "Other files" : "Other infostore folders");
            subfolderIDs.add(new String[]{String.valueOf(14), name});
        }
        return subfolderIDs;
    }

    private static boolean showPersonalBelowInfoStore(Session session, boolean altNames) {
        if (!altNames) {
            return false;
        }
        String paramName = "com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore";
        Boolean tmp = (Boolean)session.getParameter("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore");
        if (null != tmp) {
            return tmp;
        }
        ConfigViewFactory configViewFactory = ServerServiceRegistry.getInstance().getService(ConfigViewFactory.class);
        if (null == configViewFactory) {
            return false;
        }
        try {
            ConfigView view = configViewFactory.getView(session.getUserId(), session.getContextId());
            Boolean b = (Boolean)view.opt("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore", Boolean.TYPE, (Object)Boolean.FALSE);
            if (session instanceof PutIfAbsent) {
                ((PutIfAbsent)session).setParameterIfAbsent("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore", (Object)b);
            } else {
                session.setParameter("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore", (Object)b);
            }
            return b;
        }
        catch (OXException e) {
            LOGGER.debug("", (Throwable)e);
            return false;
        }
    }

    private static int getDefaultInfoStoreFolderId(Session session, Context ctx, Connection connection) {
        int folderID;
        String parameterName;
        block7: {
            parameterName = "com.openexchange.folderstorage.defaultInfoStoreFolderId";
            String parameterValue = (String)session.getParameter(parameterName);
            if (null != parameterValue) {
                try {
                    return Integer.parseInt(parameterValue);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Error parsing folder ID from session parameter", (Throwable)e);
                }
            }
            folderID = -1;
            try {
                folderID = new OXFolderAccess(connection, ctx).getDefaultFolderID(session.getUserId(), 8);
            }
            catch (OXException e) {
                if (OXFolderExceptionCode.NO_DEFAULT_FOLDER_FOUND.equals(e)) break block7;
                LOGGER.warn("Error gettting default infostore folder ID", (Throwable)e);
                return folderID;
            }
        }
        if (PutIfAbsent.class.isInstance(session)) {
            ((PutIfAbsent)session).setParameterIfAbsent(parameterName, (Object)String.valueOf(folderID));
        } else {
            session.setParameter(parameterName, (Object)String.valueOf(folderID));
        }
        return folderID;
    }
}

