/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage;

import com.openexchange.folderstorage.DefaultPermission;
import com.openexchange.folderstorage.Permission;
import gnu.trove.map.hash.TIntIntHashMap;

public class Permissions {
    private static final int MAX_PERMISSION = 64;
    private static final int[] MAPPING_0 = new int[]{0, 2, 4, -1, 8};
    private static final TIntIntHashMap MAPPING_1 = new TIntIntHashMap(6){
        {
            this.put(128, 64);
            this.put(64, 64);
            this.put(0, 0);
            this.put(2, 1);
            this.put(4, 2);
            this.put(8, 4);
        }
    };

    public static final int[] parsePermissionBits(int permissionBits) {
        int bits = permissionBits;
        int[] retval = new int[5];
        for (int i = retval.length - 1; i >= 0; --i) {
            int shiftVal = i * 7;
            retval[i] = bits >> shiftVal;
            bits -= retval[i] << shiftVal;
            retval[i] = retval[i] == 64 ? 128 : (i < retval.length - 1 ? MAPPING_0[retval[i]] : retval[i]);
        }
        return retval;
    }

    public static int createPermissionBits(Permission permission) {
        return Permissions.createPermissionBits(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission(), permission.isAdmin());
    }

    public static int createPermissionBits(int fp, int rp, int wp, int dp, boolean adminFlag) {
        int retval = 0;
        int i = 4;
        retval += (adminFlag ? 1 : 0) << i-- * 7;
        retval += MAPPING_1.get(dp) << i-- * 7;
        retval += MAPPING_1.get(wp) << i-- * 7;
        retval += MAPPING_1.get(rp) << i-- * 7;
        return retval += MAPPING_1.get(fp) << i * 7;
    }

    public static Permission createPermission(int entity, boolean isGroup, int permissionBits) {
        return new DefaultPermission(entity, isGroup, permissionBits);
    }
}

