/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum FolderExceptionErrorMessage implements DisplayableOXExceptionCode
{
    UNEXPECTED_ERROR("Unexpected error: %1$s", Category.CATEGORY_ERROR, 1001),
    IO_ERROR("I/O error: %1$s", Category.CATEGORY_ERROR, 1002),
    FOLDER_NOT_VISIBLE("Folder \"%1$s\" is not visible to user \"%2$s\" in context \"%3$s\"", Category.CATEGORY_PERMISSION_DENIED, 3, "You do not have appropriate permissions to view the folder."),
    NO_STORAGE_FOR_ID("No appropriate folder storage for tree identifier \"%1$s\" and folder identifier \"%2$s\".", Category.CATEGORY_ERROR, 1004),
    NO_STORAGE_FOR_CT("No appropriate folder storage for tree identifier \"%1$s\" and content type \"%2$s\".", Category.CATEGORY_ERROR, 1005),
    MISSING_SESSION("Missing session.", Category.CATEGORY_ERROR, 1006, "You do not have a valid session. Please login again."),
    SQL_ERROR("SQL error: %1$s", Category.CATEGORY_ERROR, 1007, "Error while reading/writing data from/to the database."),
    NOT_FOUND("Folder \"%1$s\" could not be found in tree \"%2$s\".", Category.CATEGORY_ERROR, 8, "The folder you requested does not exist."),
    MISSING_TREE_ID("Missing tree identifier.", Category.CATEGORY_ERROR, 1009),
    MISSING_PARENT_ID("Missing parent folder identifier.", Category.CATEGORY_ERROR, 1010),
    MISSING_FOLDER_ID("Missing folder identifier.", Category.CATEGORY_ERROR, 1011),
    INVALID_CONTENT_TYPE("Parent folder \"%1$s\" does not allow folder content type \"%2$s\" in tree \"%3$s\" for user %4$s in context %5$s.", Category.CATEGORY_ERROR, 1012, "The content type you provided is not allowed for the given folder."),
    MOVE_NOT_PERMITTED("Move operation not permitted for folder \"%1$s\" for user %2$s in context %3$s.", Category.CATEGORY_ERROR, 1013, "You do not have appropriate permissions to move the folder."),
    EQUAL_NAME("A folder named \"%1$s\" already exists below parent folder \"%2$s\" in tree \"%3$s\".", Category.CATEGORY_PERMISSION_DENIED, 1014, "A folder named \"%1$s\" already exists."),
    NO_REAL_SUBSCRIBE("Subscribe operation not permitted on tree \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 1015),
    NO_REAL_UNSUBSCRIBE("Unsubscribe operation not permitted on tree \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 1016),
    NO_UNSUBSCRIBE("Unsubscribe operation not permitted on folder \"%1$s\" in tree \"%2$s\". Unsubscribe subfolders first.", Category.CATEGORY_PERMISSION_DENIED, 1017),
    UNKNOWN_CONTENT_TYPE("Unknown content type: %1$s.", Category.CATEGORY_ERROR, 1018),
    MISSING_PARAMETER("Missing parameter: %1$s.", Category.CATEGORY_ERROR, 1019),
    UNSUPPORTED_STORAGE_TYPE("Unsupported storage type: %1$s.", Category.CATEGORY_ERROR, 1020),
    MISSING_PROPERTY("Missing property: %1$s.", Category.CATEGORY_ERROR, 1021),
    CONCURRENT_MODIFICATION("The object has been changed in the meantime.", Category.CATEGORY_CONFLICT, 1022),
    JSON_ERROR("JSON error: %1$s", Category.CATEGORY_ERROR, 1023),
    NO_DEFAULT_FOLDER("No default folder available for content type \"%1$s\" in tree \"%2$s\".", Category.CATEGORY_ERROR, 1024),
    INVALID_FOLDER_ID("Invalid folder identifier: %1$s.", Category.CATEGORY_ERROR, 1025),
    FOLDER_NOT_DELETEABLE("Folder \"%1$s\" must not be deleted by user \"%2$s\" in context \"%3$s\".", Category.CATEGORY_PERMISSION_DENIED, 1026, "You do not have the appropriate permissions to delete the folder."),
    FOLDER_NOT_MOVEABLE("Folder \"%1$s\" must not be moved by user \"%2$s\" in context \"%3$s\".", Category.CATEGORY_PERMISSION_DENIED, 1027, "You do not have the appropriate permissions to move the folder."),
    TEMPORARY_ERROR("A temporary error occurred. Please retry.", Category.CATEGORY_ERROR, 1028),
    NO_CREATE_SUBFOLDERS("User \"%2$s\" must not create subfolders below folder \"%2$s\" in context \"%3$s\".", Category.CATEGORY_PERMISSION_DENIED, 1029, "You do not have the appropriate permissions to create a subfolder."),
    NO_PUBLIC_MAIL_FOLDER("No mail folder allowed below a public folder.", Category.CATEGORY_PERMISSION_DENIED, 1030, "It is not allowed to create a mail folder below a public folder."),
    TREE_NOT_FOUND("No such tree with identifier \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 1031),
    DUPLICATE_TREE("A tree with identifier \"%1$s\" already exists.", Category.CATEGORY_ERROR, 1032),
    RESERVED_NAME("The folder name \"%1$s\" is reserved. Please choose another name.", Category.CATEGORY_PERMISSION_DENIED, 1033, "The folder name \"%1$s\" is reserved. Please choose another name."),
    DUPLICATE_NAME("Found two folders named \"%1$s\" located below the parent folder \"%2$s\". Please rename one of the folders. There should be no two folders with the same name.", Category.CATEGORY_PERMISSION_DENIED, 1034, "Found two folders named \"%1$s\" located below the parent folder. Please rename one of the folders. There should be no two folders with the same name."),
    TRY_AGAIN("An unexpected error occurred: %1$s. Please try again.", Category.CATEGORY_TRY_AGAIN, 1035),
    INVALID_SESSION("Specified session is invalid: %1$s", Category.CATEGORY_ERROR, 1036),
    FOLDER_DELETION_FAILED("Failed to delete following folder/s: %1$s", Category.CATEGORY_ERROR, 1037, "Failed to delete all folders"),
    FOLDER_UPDATE_ABORTED("Folder update aborted: %2$s", Category.CATEGORY_CONFLICT, 1038, "The folder was not updated due to possible data loss. Please review the warnings for details."),
    INVALID_PERMISSIONS("The set permissions (%1$d) are invalid for entity (%2$d) on object %3$s.", Category.CATEGORY_PERMISSION_DENIED, 1039),
    ILLEGAL_CHARACTERS("Folder name contains illegal characters: \"%1$s\"", Category.CATEGORY_USER_INPUT, 1040, "Folder name contains illegal characters: \"%1$s\"");

    private static final String PREFIX = "FLD";
    private final Category category;
    private final int detailNumber;
    private final String message;
    private final String displayMessage;

    public static String prefix() {
        return PREFIX;
    }

    private FolderExceptionErrorMessage(String message, Category category, int detailNumber) {
        this(message, category, detailNumber, null);
    }

    private FolderExceptionErrorMessage(String message, Category category, int detailNumber, String displayMessage) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return this.specials(OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]));
    }

    public OXException create(Object ... args) {
        return this.specials(OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args));
    }

    public OXException create(Throwable cause, Object ... args) {
        return this.specials(OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args));
    }

    private OXException specials(OXException exc) {
        switch (this) {
            case NOT_FOUND: {
                exc.setGeneric(OXException.Generic.NOT_FOUND);
            }
        }
        if (exc.getCategories().contains(Category.CATEGORY_CONFLICT)) {
            exc.setGeneric(OXException.Generic.CONFLICT);
        }
        if (exc.getCategories().contains(Category.CATEGORY_PERMISSION_DENIED)) {
            exc.setGeneric(OXException.Generic.NO_PERMISSION);
        }
        return exc;
    }
}

