/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.event.impl;

import com.openexchange.event.impl.EventConfig;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.java.Streams;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConfigImpl
extends AbstractConfigWrapper
implements EventConfig {
    private boolean isEventQueueEnabled;
    private int eventQueueDelay = 60000;
    private static final Logger LOG = LoggerFactory.getLogger(EventConfigImpl.class);

    public EventConfigImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventConfigImpl(File propfile) {
        if (propfile == null) {
            LOG.error("missing propfile");
            return;
        }
        Properties prop = null;
        try {
            LOG.debug("try to load propfile: {}", (Object)propfile);
            prop = new Properties();
            FileInputStream in = new FileInputStream(propfile);
            try {
                prop.load(in);
            }
            finally {
                Streams.close((Closeable)in);
            }
        }
        catch (FileNotFoundException exc) {
            LOG.error("Cannot find propfile: {}", (Object)propfile, (Object)exc);
        }
        catch (IOException exc) {
            LOG.error("Cannot read propfile: {}", (Object)propfile, (Object)exc);
        }
        this.isEventQueueEnabled = EventConfigImpl.parseProperty(prop, "com.openexchange.event.isEventQueueEnabled", false);
        LOG.debug("Event property: com.openexchange.event.isEventQueueEnabled={}", (Object)this.isEventQueueEnabled);
        this.eventQueueDelay = EventConfigImpl.parseProperty(prop, "com.openexchange.event.eventQueueDelay", this.eventQueueDelay);
        LOG.debug("Event property: com.openexchange.event.eventQueueDelay={}", (Object)this.eventQueueDelay);
    }

    @Override
    public boolean isEventQueueEnabled() {
        return this.isEventQueueEnabled;
    }

    @Override
    public void setEventQueueEnabled(boolean isEventQueueEnabled) {
        this.isEventQueueEnabled = isEventQueueEnabled;
    }

    @Override
    public int getEventQueueDelay() {
        return this.eventQueueDelay;
    }

    @Override
    public void setEventQueueDelay(int eventQueueDelay) {
        this.eventQueueDelay = eventQueueDelay;
    }
}

