/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal;

import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.Operand;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.SingleSearchTerm;
import java.util.ArrayList;
import java.util.List;

public class SearchTermAnalyzer {
    private final List<String> folderIDs = new ArrayList<String>();

    public SearchTermAnalyzer(SearchTerm<?> term) {
        this.analyzeTerm(term);
    }

    public List<String> getFolderIDs() {
        return this.folderIDs;
    }

    public boolean hasFolderIDs() {
        return null != this.folderIDs && 0 < this.folderIDs.size();
    }

    private void analyzeTerm(SearchTerm<?> term) {
        if (SingleSearchTerm.class.isInstance(term)) {
            this.analyzeTerm((SingleSearchTerm)term);
        } else if (CompositeSearchTerm.class.isInstance(term)) {
            this.analyzeTerm((CompositeSearchTerm)term);
        } else {
            throw new IllegalArgumentException("Need either a 'SingleSearchTerm' or 'CompositeSearchTerm'.");
        }
    }

    private void analyzeTerm(SingleSearchTerm term) {
        Operand[] operands = term.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            if (Operand.Type.COLUMN != operands[i].getType()) continue;
            ContactField field = null;
            Object value = operands[i].getValue();
            if (null == value) {
                throw new IllegalArgumentException("column operand without value: " + operands[i]);
            }
            field = ContactField.class.isInstance(value) ? (ContactField)((Object)value) : ContactField.getByAjaxName(value.toString());
            if (null == field || !ContactField.FOLDER_ID.equals((Object)field) || i + 1 >= operands.length || null == operands[i + 1] || null == operands[i + 1].getValue()) continue;
            this.folderIDs.add((String)operands[i + 1].getValue());
            ++i;
        }
    }

    private void analyzeTerm(CompositeSearchTerm term) {
        for (SearchTerm operand : term.getOperands()) {
            this.analyzeTerm(operand);
        }
    }
}

