/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cache.impl;

import java.io.Serializable;

public class QueryCacheKey
implements Serializable {
    private static final long serialVersionUID = -8531547389903446885L;
    private final int cid;
    private final int userId;
    private final Module module;
    private final int queryNum;
    private final int hash;

    public QueryCacheKey(int cid, int userId, Module module, int queryNum) {
        this.cid = cid;
        this.userId = userId;
        this.module = module;
        this.queryNum = queryNum;
        this.hash = queryNum ^ (module.getNum() ^ (userId ^ cid));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QueryCacheKey)) {
            return false;
        }
        QueryCacheKey other = (QueryCacheKey)obj;
        return this.cid == other.cid && this.userId == other.userId && this.module.num == other.module.num && this.queryNum == other.queryNum;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return new StringBuilder(50).append("QueryCacheKey context=").append(this.cid).append(" | userId=").append(this.userId).append(" | module=").append(this.module.num).append(" | queryNum=").append(this.queryNum).toString();
    }

    public static enum Module {
        FOLDER(1);

        private int num;

        private Module(int num) {
            this.num = num;
        }

        public int getNum() {
            return this.num;
        }
    }
}

