/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.authentication.service.osgi;

import com.openexchange.authentication.AuthenticationService;
import com.openexchange.authentication.service.osgi.AuthenticationCustomizer;
import com.openexchange.authentication.service.osgi.BasicAuthenticationRegisterer;
import com.openexchange.context.ContextService;
import com.openexchange.user.UserService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthenticationActivator
implements BundleActivator {
    private volatile ServiceTracker<AuthenticationService, AuthenticationService> authTracker;
    private volatile ServiceTracker<Object, Object> basicAuthTracker;

    public void start(BundleContext context) throws Exception {
        try {
            ServiceTracker tracker;
            ServiceTracker tracker2;
            this.authTracker = tracker2 = new ServiceTracker(context, AuthenticationService.class.getName(), (ServiceTrackerCustomizer)new AuthenticationCustomizer(context));
            tracker2.open();
            Filter filter = context.createFilter("(|(objectClass=" + ContextService.class.getName() + ")(" + "objectClass" + '=' + UserService.class.getName() + "))");
            BasicAuthenticationRegisterer registerer = new BasicAuthenticationRegisterer(context);
            this.basicAuthTracker = tracker = new ServiceTracker(context, filter, (ServiceTrackerCustomizer)registerer);
            tracker.open();
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(AuthenticationActivator.class);
            logger.error("Failed to start-up bundle {}", (Object)context.getBundle().getSymbolicName(), (Object)e);
            throw e;
        }
    }

    public void stop(BundleContext context) {
        ServiceTracker<Object, Object> basicAuthTracker;
        ServiceTracker<AuthenticationService, AuthenticationService> authTracker = this.authTracker;
        if (null != authTracker) {
            authTracker.close();
            this.authTracker = null;
        }
        if (null != (basicAuthTracker = this.basicAuthTracker)) {
            basicAuthTracker.close();
            this.basicAuthTracker = null;
        }
    }
}

