/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.auth.mbean.impl;

import com.openexchange.auth.Authenticator;
import com.openexchange.auth.Credentials;
import com.openexchange.auth.mbean.AuthenticatorMBean;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthenticatorMBeanImpl
extends StandardMBean
implements AuthenticatorMBean {
    public AuthenticatorMBeanImpl() throws NotCompliantMBeanException {
        super(AuthenticatorMBean.class);
    }

    public boolean isMasterAuthenticationDisabled() throws MBeanException {
        Logger logger = LoggerFactory.getLogger(AuthenticatorMBeanImpl.class);
        try {
            Authenticator authenticator = ServerServiceRegistry.getInstance().getService(Authenticator.class);
            if (null == authenticator) {
                throw ServiceExceptionCode.absentService(Authenticator.class);
            }
            return authenticator.isMasterAuthenticationDisabled();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new MBeanException(new Exception(message), message);
        }
    }

    public boolean isContextAuthenticationDisabled() throws MBeanException {
        Logger logger = LoggerFactory.getLogger(AuthenticatorMBeanImpl.class);
        try {
            Authenticator authenticator = ServerServiceRegistry.getInstance().getService(Authenticator.class);
            if (null == authenticator) {
                throw ServiceExceptionCode.absentService(Authenticator.class);
            }
            return authenticator.isContextAuthenticationDisabled();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new MBeanException(new Exception(message), message);
        }
    }

    public void doAuthentication(String login, String password) throws MBeanException {
        Logger logger = LoggerFactory.getLogger(AuthenticatorMBeanImpl.class);
        try {
            Authenticator authenticator = ServerServiceRegistry.getInstance().getService(Authenticator.class);
            if (null == authenticator) {
                throw ServiceExceptionCode.absentService(Authenticator.class);
            }
            authenticator.doAuthentication(new Credentials(login, password));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new MBeanException(new Exception(message), message);
        }
    }

    public void doAuthentication(String login, String password, int contextId) throws MBeanException {
        Logger logger = LoggerFactory.getLogger(AuthenticatorMBeanImpl.class);
        try {
            Authenticator authenticator = ServerServiceRegistry.getInstance().getService(Authenticator.class);
            if (null == authenticator) {
                throw ServiceExceptionCode.absentService(Authenticator.class);
            }
            authenticator.doAuthentication(new Credentials(login, password), contextId);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new MBeanException(new Exception(message), message);
        }
    }

    public void doUserAuthentication(String login, String password, int contextId) throws MBeanException {
        Logger logger = LoggerFactory.getLogger(AuthenticatorMBeanImpl.class);
        try {
            Authenticator authenticator = ServerServiceRegistry.getInstance().getService(Authenticator.class);
            if (null == authenticator) {
                throw ServiceExceptionCode.absentService(Authenticator.class);
            }
            authenticator.doUserAuthentication(new Credentials(login, password), contextId);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new MBeanException(new Exception(message), message);
        }
    }
}

