/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers.actions;

import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.ajax.fileholder.PushbackReadable;
import com.openexchange.ajax.fileholder.Readable;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.responseRenderers.FileResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.IDataWrapper;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.IFileResponseRendererAction;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.tools.io.IOUtils;
import com.openexchange.tools.servlet.http.Tools;
import com.sun.mail.util.MessageRemovedIOException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputBinaryContentAction
implements IFileResponseRendererAction {
    private static final Logger LOG = LoggerFactory.getLogger(FileResponseRenderer.class);
    private static final int BUFLEN = 10240;
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";

    @Override
    public void call(IDataWrapper data) throws Exception {
        try {
            ServletOutputStream outputStream = data.getResponse().getOutputStream();
            String sRange = data.getRequest().getHeader("Range");
            if (data.getLength() > 0L && null != sRange) {
                Range r;
                List<Range> ranges;
                if (!Tools.isByteRangeHeader(sRange)) {
                    data.getResponse().setHeader("Content-Range", "bytes */" + data.getLength());
                    data.getResponse().sendError(416);
                    return;
                }
                boolean full = false;
                String ifRange = data.getRequestData().getHeader("If-Range");
                String eTag = data.getResult().getHeader("ETag");
                if (ifRange != null && !ifRange.equals(eTag)) {
                    try {
                        long ifRangeTime = data.getRequest().getDateHeader("If-Range");
                        if (ifRangeTime != -1L && ifRangeTime < data.getResult().getExpires()) {
                            full = true;
                        }
                    }
                    catch (IllegalArgumentException ignore) {
                        full = true;
                    }
                }
                if (full) {
                    ranges = Collections.emptyList();
                } else {
                    String[] parts = Strings.splitByComma((String)sRange.substring(6));
                    ranges = new ArrayList<Range>(parts.length);
                    for (String part : parts) {
                        int dashPos = part.indexOf(45);
                        long start = this.sublong(part, 0, dashPos);
                        long end = this.sublong(part, dashPos + 1, part.length());
                        if (start == -1L) {
                            start = data.getLength() - end;
                            end = data.getLength() - 1L;
                        } else if (end == -1L || end > data.getLength() - 1L) {
                            end = data.getLength() - 1L;
                        }
                        if (start > end) {
                            data.getResponse().setHeader("Content-Range", "bytes */" + data.getLength());
                            data.getResponse().sendError(416);
                            return;
                        }
                        ranges.add(new Range(start, end, data.getLength()));
                    }
                }
                if (full || ranges.isEmpty()) {
                    r = new Range(0L, data.getLength() - 1L, data.getLength());
                    data.getResponse().setHeader("Content-Range", "bytes " + r.start + '-' + r.end + '/' + r.total);
                    OutputBinaryContentAction.copy(data.getDocumentData(), (OutputStream)outputStream);
                } else if (ranges.size() == 1) {
                    r = ranges.get(0);
                    data.getResponse().setHeader("Content-Range", "bytes " + r.start + '-' + r.end + '/' + r.total);
                    data.getResponse().setHeader("Content-Length", Long.toString(r.length));
                    data.getResponse().setStatus(206);
                    this.copy(data.getDocumentData(), (OutputStream)outputStream, r.start, r.length);
                } else {
                    String boundary = MULTIPART_BOUNDARY;
                    data.getResponse().setContentType("multipart/byteranges; boundary=" + MULTIPART_BOUNDARY);
                    data.getResponse().setStatus(206);
                    for (Range r2 : ranges) {
                        outputStream.println();
                        outputStream.println("--" + MULTIPART_BOUNDARY);
                        outputStream.println("Content-Type: " + data.getContentType());
                        outputStream.println("Content-Range: bytes " + r2.start + '-' + r2.end + '/' + r2.total);
                        this.copy(data.getDocumentData(), (OutputStream)outputStream, r2.start, r2.length);
                    }
                    outputStream.println();
                    outputStream.println("--" + MULTIPART_BOUNDARY + "--");
                }
            } else {
                int off = AJAXRequestDataTools.parseIntParameter(data.getRequest().getParameter("off"), -1);
                int amount = AJAXRequestDataTools.parseIntParameter(data.getRequest().getParameter("len"), -1);
                if (off >= 0 && amount > 0) {
                    try {
                        data.getResponse().setHeader("Content-Length", Long.toString(amount));
                        this.copy(data.getDocumentData(), (OutputStream)outputStream, off, amount);
                    }
                    catch (OffsetOutOfRangeIOException e) {
                        this.setHeaderSafe("Content-Range", "bytes */" + e.getAvailable(), data.getResponse());
                        data.getResponse().sendError(416);
                        return;
                    }
                } else {
                    OutputBinaryContentAction.copy(data.getDocumentData(), (OutputStream)outputStream);
                }
            }
            outputStream.flush();
        }
        catch (SocketException e) {
            String lmsg = Strings.toLowerCase((CharSequence)e.getMessage());
            if ("broken pipe".equals(lmsg) || "connection reset".equals(lmsg)) {
                LOG.debug("Underlying (TCP) protocol communication aborted while trying to output file{}", (Object)(Strings.isEmpty((String)data.getFileName()) ? "" : " " + data.getFileName()), (Object)e);
            } else {
                LOG.warn("Lost connection to client while trying to output file{}", (Object)(Strings.isEmpty((String)data.getFileName()) ? "" : " " + data.getFileName()), (Object)e);
            }
        }
        catch (MessageRemovedIOException e) {
            this.sendErrorSafe(404, "Message not found.", data.getResponse());
        }
        catch (IOException e) {
            String lcm = Strings.toLowerCase((CharSequence)e.getMessage());
            if ("connection reset by peer".equals(lcm) || "broken pipe".equals(lcm)) {
                LOG.debug("Client dropped connection while trying to output file{}", (Object)(Strings.isEmpty((String)data.getFileName()) ? "" : " " + data.getFileName()), (Object)e);
            }
            LOG.warn("Lost connection to input or output end-point while trying to output file{}", (Object)(Strings.isEmpty((String)data.getFileName()) ? "" : " " + data.getFileName()), (Object)e);
        }
    }

    private long sublong(String value, int beginIndex, int endIndex) {
        String substring = value.substring(beginIndex, endIndex);
        return substring.length() > 0 ? Long.parseLong(substring) : -1L;
    }

    private void setHeaderSafe(String name, String value, HttpServletResponse resp) {
        try {
            resp.setHeader(name, value);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void sendErrorSafe(int sc, String msg, HttpServletResponse resp) {
        try {
            resp.sendError(sc, msg);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void copy(IFileHolder.RandomAccess input, OutputStream output, long start, long length) throws IOException, OXException {
        if (input.length() == length) {
            OutputBinaryContentAction.copy((Readable)input, output);
        } else {
            int read;
            input.seek(start);
            long toRead = length;
            PushbackReadable readMe = new PushbackReadable((Readable)input);
            byte[] bs = new byte[1];
            int first = readMe.read(bs);
            if (first <= 0) {
                throw new OffsetOutOfRangeIOException(start, input.length());
            }
            readMe.unread(bs[0] & 0xFF);
            int buflen = 10240;
            byte[] buffer = new byte[buflen];
            while ((read = readMe.read(buffer, 0, buflen)) > 0) {
                if ((toRead -= (long)read) > 0L) {
                    output.write(buffer, 0, read);
                    continue;
                }
                output.write(buffer, 0, (int)toRead + read);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(Readable input, OutputStream output) throws IOException, OXException {
        if (IFileHolder.InputStreamClosure.class.isInstance(input)) {
            InputStream stream = null;
            try {
                stream = ((IFileHolder.InputStreamClosure)input).newStream();
                IOUtils.transfer(stream, output);
            }
            finally {
                Streams.close((Closeable)stream);
            }
        } else {
            int read;
            int buflen = 10240;
            byte[] buffer = new byte[buflen];
            while ((read = input.read(buffer, 0, buflen)) > 0) {
                output.write(buffer, 0, read);
            }
        }
    }

    private void copy(Readable inputStream, OutputStream output, long start, long length) throws IOException, OXException {
        int read;
        if (inputStream instanceof IFileHolder.RandomAccess) {
            OutputBinaryContentAction.copy((IFileHolder.RandomAccess)inputStream, output, start, length);
            return;
        }
        byte[] buffer = new byte[1];
        int i = 0;
        while ((long)i < start) {
            if (inputStream.read(buffer, 0, 1) < 0) {
                throw new OffsetOutOfRangeIOException(start, i);
            }
            ++i;
        }
        long toRead = length;
        int buflen = 10240;
        buffer = new byte[buflen];
        while ((read = inputStream.read(buffer, 0, buflen)) > 0) {
            if ((toRead -= (long)read) > 0L) {
                output.write(buffer, 0, read);
                continue;
            }
            output.write(buffer, 0, (int)toRead + read);
            break;
        }
    }

    private static final class OffsetOutOfRangeIOException
    extends IOException {
        private static final long serialVersionUID = 8094333124726048736L;
        private final long off;
        private final long available;

        public OffsetOutOfRangeIOException(long off, long available) {
            super("Offset " + off + " out of range. Got only " + available);
            this.off = off;
            this.available = available;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        public long getOff() {
            return this.off;
        }

        public long getAvailable() {
            return this.available;
        }
    }

    private static final class Range {
        final long start;
        final long end;
        final long length;
        final long total;

        Range(long start, long end, long total) {
            this.start = start;
            this.end = end;
            this.length = end - start + 1L;
            this.total = total;
        }
    }
}

