/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.osgi;

import com.openexchange.ajax.requesthandler.converters.cover.CoverExtractor;
import com.openexchange.ajax.requesthandler.converters.cover.CoverExtractorRegistry;
import com.openexchange.ajax.requesthandler.converters.cover.Mp3CoverExtractor;
import com.openexchange.exception.OXException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class OSGiCoverExtractorRegistry
implements CoverExtractorRegistry,
ServiceTrackerCustomizer<CoverExtractor, CoverExtractor> {
    private static final Object PRESENT = new Object();
    private final ConcurrentMap<CoverExtractor, Object> map;
    private final BundleContext context;

    public OSGiCoverExtractorRegistry(BundleContext context) {
        this.context = context;
        this.map = new ConcurrentHashMap<CoverExtractor, Object>();
        this.map.put(new Mp3CoverExtractor(), PRESENT);
    }

    @Override
    public Collection<CoverExtractor> getExtractors() throws OXException {
        return Collections.unmodifiableCollection(this.map.keySet());
    }

    public CoverExtractor addingService(ServiceReference<CoverExtractor> reference) {
        CoverExtractor coverExtractor = (CoverExtractor)this.context.getService(reference);
        if (null == this.map.putIfAbsent(coverExtractor, PRESENT)) {
            return coverExtractor;
        }
        this.context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference<CoverExtractor> reference, CoverExtractor service) {
    }

    public void removedService(ServiceReference<CoverExtractor> reference, CoverExtractor service) {
        this.map.remove(service);
        this.context.ungetService(reference);
    }
}

