/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache.groupware;

import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.converters.preview.cache.ResourceCacheMBeanImpl;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteListener;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewCacheDeleteListener
implements DeleteListener {
    @Override
    public void deletePerformed(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        if (event.getType() == 1) {
            this.deleteUserEntriesFromDB(event, writeCon);
        } else if (event.getType() == 5) {
            this.deleteContextEntries(event.getContext().getContextId(), writeCon);
        }
    }

    protected void deleteContextEntries(int contextId, Connection writeCon) throws OXException {
        ResourceCache resourceCache = ResourceCacheMBeanImpl.CACHE_REF.get();
        if (null != resourceCache) {
            try {
                resourceCache.clearFor(contextId);
            }
            catch (Exception e) {
                Logger logger = LoggerFactory.getLogger(PreviewCacheDeleteListener.class);
                logger.warn("Failed to clean resource cache for deleted context {}", (Object)contextId, (Object)e);
            }
        }
    }

    private void deleteUserEntriesFromDB(DeleteEvent event, Connection writeCon) throws OXException {
        int contextId = event.getContext().getContextId();
        int userId = event.getId();
        ResourceCache resourceCache = ResourceCacheMBeanImpl.CACHE_REF.get();
        if (null != resourceCache) {
            try {
                resourceCache.remove(userId, contextId);
            }
            catch (Exception e) {
                Logger logger = LoggerFactory.getLogger(PreviewCacheDeleteListener.class);
                logger.warn("Failed to clean resource cache for deleted user {} in context {}", new Object[]{userId, contextId, e});
            }
        }
    }
}

