/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewConst;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewImageGenerator;
import com.openexchange.ajax.requesthandler.converters.preview.cache.CacheKeyGenerator;
import com.openexchange.caching.CacheExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.preview.PreviewService;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CancellationException;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewAndCacheTask
extends AbstractTask<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(PreviewAndCacheTask.class);
    private final PreviewService previewService;
    private final long threshold;
    private final AJAXRequestResult result;
    private final AJAXRequestData requestData;
    private final ServerSession session;
    private final boolean respectLanguage;
    private final CacheKeyGenerator cacheKeyGenerator;

    public PreviewAndCacheTask(AJAXRequestResult result, AJAXRequestData requestData, ServerSession session, PreviewService previewService, long threshold, boolean respectLanguage, CacheKeyGenerator cacheKeyGenerator) {
        Validate.notNull((Object)result);
        Validate.notNull((Object)requestData);
        Validate.notNull((Object)session);
        Validate.notNull((Object)previewService);
        Validate.notNull((Object)cacheKeyGenerator);
        this.result = result;
        this.requestData = requestData;
        this.session = session;
        this.previewService = previewService;
        this.threshold = threshold;
        this.respectLanguage = respectLanguage;
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    public Void call() throws Exception {
        block11: {
            int userId;
            int contextId = this.session.getContextId();
            ResourceCache resourceCache = AbstractPreviewResultConverter.getResourceCache(contextId, userId = this.session.getUserId());
            if (resourceCache == null) {
                LOG.error("Unable to get ResourceCache for user {} in context {}");
                return null;
            }
            String cacheKey = this.cacheKeyGenerator.generateCacheKey();
            if (cacheKey == null) {
                LOG.error("Refusing to generate and cache preview without valid cache key");
                return null;
            }
            try {
                InputStream thumbnail;
                PreviewDocument previewDocument;
                try {
                    previewDocument = PreviewImageGenerator.getPreviewDocument(this.result, this.requestData, this.session, this.previewService, this.threshold, this.respectLanguage, cacheKey);
                }
                catch (OXException e) {
                    if (PreviewExceptionCodes.THUMBNAIL_NOT_AVAILABLE.equals(e)) {
                        LOG.debug("Thumbnail has not been generated in time.", (Throwable)e);
                        return null;
                    }
                    if (PreviewExceptionCodes.NO_PREVIEW_SERVICE.equals(e)) {
                        LOG.debug("", (Throwable)e);
                        return null;
                    }
                    throw e;
                }
                if (previewDocument == null || previewDocument == PreviewConst.DEFAULT_PREVIEW_DOCUMENT || (thumbnail = previewDocument.getThumbnail()) == null) break block11;
                try {
                    byte[] thumbnailBytes = Streams.stream2bytes((InputStream)thumbnail);
                    String fileName = (String)previewDocument.getMetaData().get("resourcename");
                    this.syncToCache(thumbnailBytes, cacheKey, fileName, resourceCache, this.session);
                }
                catch (IOException ioex) {
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(ioex, ioex.getMessage());
                }
            }
            catch (CancellationException e) {
                LOG.debug("Thumbnail generation has been cancelled.", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("Error while trying to get PreviewDocument.", (Throwable)e);
            }
        }
        return null;
    }

    private void syncToCache(byte[] input, String cacheKey, String fileName, ResourceCache resourceCache, ServerSession session) throws OXException {
        if (null != resourceCache && null != cacheKey) {
            try {
                CachedResource preview = new CachedResource(input, fileName, "image/jpeg", (long)input.length);
                resourceCache.save(cacheKey, preview, 0, session.getContextId());
                LOG.debug("Cached resource {} with key {}", (Object)fileName, (Object)cacheKey);
            }
            catch (OXException e) {
                throw CacheExceptionCode.FAILED_PUT.create((Throwable)e, new Object[0]);
            }
        }
    }
}

