/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.request.SimpleRequest;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonRequest {
    protected JSONWriter w;
    private final Logger LOG = LoggerFactory.getLogger(CommonRequest.class);

    public CommonRequest(JSONWriter w) {
        this.w = w;
    }

    private static Locale localeFrom(Session session) throws OXException {
        if (null == session) {
            return Locale.US;
        }
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser().getLocale();
        }
        return UserStorage.getInstance().getUser(session.getUserId(), session.getContextId()).getLocale();
    }

    protected void sendErrorAsJS(String error, String ... errorParams) {
        try {
            this.w.object();
            this.w.key("error").value((Object)error);
            this.w.key("error_params").value((Object)new JSONArray(Arrays.asList(errorParams)));
            this.w.endArray();
        }
        catch (JSONException e) {
            this.LOG.debug("", (Throwable)e);
        }
    }

    protected void handle(Throwable t, Session session) {
        Response res = new Response();
        if (t instanceof OXException) {
            OXException e = (OXException)t;
            switch (((Category)e.getCategories().get(0)).getLogLevel()) {
                case TRACE: {
                    this.LOG.trace("", (Throwable)e);
                    break;
                }
                case DEBUG: {
                    this.LOG.debug("", (Throwable)e);
                    break;
                }
                case INFO: {
                    this.LOG.info("", (Throwable)e);
                    break;
                }
                case WARNING: {
                    this.LOG.warn("", (Throwable)e);
                    break;
                }
                case ERROR: {
                    this.LOG.error("", (Throwable)e);
                    break;
                }
            }
            res.setException(e);
        } else {
            this.LOG.error("", t);
            res.setException(new OXException(t));
        }
        try {
            ResponseWriter.write(res, this.w, CommonRequest.localeFrom(session));
        }
        catch (JSONException e) {
            this.LOG.error("", t);
        }
        catch (OXException e) {
            this.LOG.error("", (Throwable)e);
        }
    }

    protected void invalidParameter(String parameter, String value) {
        this.sendErrorAsJS("Invalid parameter value '%s' for parameter %s", value, parameter);
    }

    protected void unknownColumn(String columnId) {
        this.sendErrorAsJS("Unknown column id: %s", columnId);
    }

    protected boolean checkRequired(SimpleRequest req, String action, String ... parameters) {
        for (String param : parameters) {
            if (req.getParameter(param) != null) continue;
            this.missingParameter(param, action);
            return false;
        }
        return true;
    }

    protected void missingParameter(String parameter, String action) {
        this.sendErrorAsJS("Missing Parameter: %s for action: %s", parameter, action);
    }
}

