/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.ajax.parser.JSONDocumentMetadata;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.utils.Metadata;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class InfostoreParser {
    public DocumentMetadata getDocumentMetadata(String json) throws JSONException, OXException {
        JSONDocumentMetadata m = new JSONDocumentMetadata(json);
        return m;
    }

    public Metadata[] getColumns(String[] parameterValues) throws UnknownMetadataException {
        Metadata[] cols = new Metadata[parameterValues.length];
        int i = 0;
        for (String idString : parameterValues) {
            int id = -1;
            try {
                id = Integer.parseInt(idString);
            }
            catch (NumberFormatException x) {
                throw new UnknownMetadataException(idString);
            }
            Metadata m = Metadata.get(id);
            if (m == null) {
                throw new UnknownMetadataException(idString);
            }
            cols[i++] = m;
        }
        return cols;
    }

    public Metadata[] findPresentFields(String updateBody) throws UnknownMetadataException, JSONException {
        JSONObject obj = new JSONObject(updateBody);
        Metadata[] metadata = new Metadata[obj.length()];
        int i = 0;
        boolean shrink = false;
        Iterator iter = obj.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Metadata m = Metadata.get(key);
            if (m == null) {
                throw new UnknownMetadataException(key);
            }
            if (m == Metadata.FILENAME_LITERAL && (obj.optString(key) == null || obj.optString(key).equals(""))) {
                shrink = true;
                continue;
            }
            metadata[i++] = m;
        }
        if (shrink) {
            Metadata[] shrunk = new Metadata[metadata.length - 1];
            System.arraycopy(metadata, 0, shrunk, 0, shrunk.length);
            return shrunk;
        }
        return metadata;
    }

    public static class UnknownMetadataException
    extends Exception {
        private static final long serialVersionUID = 3260737756212968495L;
        private final String columnId;

        public UnknownMetadataException(String id) {
            this.columnId = id;
        }

        public String getColumnId() {
            return this.columnId;
        }
    }
}

