/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.osgi;

import com.openexchange.ajax.osgi.AbstractServletActivator;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ServerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import javax.servlet.http.HttpServlet;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionServletActivator
extends AbstractServletActivator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSessionServletActivator.class);

    protected AbstractSessionServletActivator() {
    }

    protected void registerSessionServlet(String alias, HttpServlet servlet, String ... configKeys) {
        ArrayList<String> allKeys = new ArrayList<String>(Arrays.asList(configKeys));
        allKeys.add(ServerConfig.Property.IP_CHECK.getPropertyName());
        allKeys.add(ServerConfig.Property.COOKIE_HASH.getPropertyName());
        allKeys.add(ServerConfig.Property.IP_CHECK_WHITELIST.getPropertyName());
        allKeys.add(ServerConfig.Property.IP_MASK_V4.getPropertyName());
        allKeys.add(ServerConfig.Property.IP_MASK_V6.getPropertyName());
        try {
            Hashtable<String, String> initParams = new Hashtable<String, String>();
            ConfigurationService configurationService = (ConfigurationService)this.getService(ConfigurationService.class);
            if (configurationService != null) {
                for (String configKey : allKeys) {
                    String property = configurationService.getProperty(configKey);
                    if (property == null) {
                        StringBuilder sb = new StringBuilder("Missing initialization parameter \"");
                        sb.append(configKey);
                        sb.append("\". Problem during registration of servlet \"");
                        sb.append(servlet.getClass().getName());
                        sb.append("\" into the URI namespace \"");
                        sb.append(alias);
                        sb.append("\".");
                        IllegalStateException e = new IllegalStateException(sb.toString());
                        LOG.warn("", (Throwable)e);
                        property = "";
                    }
                    ((Dictionary)initParams).put(configKey, property);
                }
                String whitelistFile = configurationService.getText("noipcheck.cnf");
                if (whitelistFile != null) {
                    ((Dictionary)initParams).put("noipcheck.cnf", whitelistFile);
                }
            }
            this.registerServlet(alias, servlet, initParams, (HttpService)this.getService(HttpService.class));
        }
        catch (IllegalStateException e) {
            LOG.error("", (Throwable)e);
        }
    }

    protected void registerServlet(String alias, HttpServlet servlet) {
        this.registerServlet(alias, servlet, (HttpService)this.getService(HttpService.class));
    }

    protected final Class<?>[] getNeededServices() {
        HashSet neededServices = new HashSet();
        neededServices.add(HttpService.class);
        neededServices.add(ConfigurationService.class);
        neededServices.add(CapabilityService.class);
        Class<?>[] additionalNeededServices = this.getAdditionalNeededServices();
        if (additionalNeededServices != null) {
            for (Class<?> clazz : additionalNeededServices) {
                neededServices.add(clazz);
            }
        }
        return neededServices.toArray(new Class[neededServices.size()]);
    }

    protected abstract Class<?>[] getAdditionalNeededServices();
}

