/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.login.AbstractShareBasedLoginRequestHandler;
import com.openexchange.ajax.login.ShareLoginConfiguration;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.LoginInfo;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.guest.GuestService;
import com.openexchange.java.Strings;
import com.openexchange.login.LoginRampUpService;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.share.AuthenticationMode;
import com.openexchange.share.GuestInfo;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.user.UserService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class GuestLogin
extends AbstractShareBasedLoginRequestHandler {
    public GuestLogin(ShareLoginConfiguration conf, Set<LoginRampUpService> rampUp) {
        super(conf, rampUp);
    }

    @Override
    protected boolean checkAuthenticationMode(AuthenticationMode authenticationMode) throws OXException {
        return AuthenticationMode.GUEST_PASSWORD == authenticationMode || AuthenticationMode.GUEST == authenticationMode;
    }

    @Override
    protected LoginInfo getLoginInfoFrom(HttpServletRequest httpRequest) throws OXException {
        try {
            String pass;
            String login;
            ConfigurationService configService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == configService) {
                throw ServiceExceptionCode.absentService(ConfigurationService.class);
            }
            String body = AJAXServlet.getBody(httpRequest);
            if (Strings.isEmpty((String)body)) {
                login = httpRequest.getParameter("name");
                if (Strings.isEmpty((String)login)) {
                    throw AjaxExceptionCodes.MISSING_PARAMETER.create("name");
                }
                pass = httpRequest.getParameter("password");
            } else {
                JSONObject jBody = new JSONObject(body);
                pass = jBody.optString("password", null);
                login = jBody.getString("login");
            }
            final HashMap loginProperties = new HashMap(1);
            return new LoginInfo(){

                public String getPassword() {
                    return pass;
                }

                public String getUsername() {
                    return login;
                }

                public Map<String, Object> getProperties() {
                    return loginProperties;
                }
            };
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    protected User authenticateUser(GuestInfo guest, LoginInfo loginInfo, Context context) throws OXException {
        UserService userService = ServerServiceRegistry.getInstance().getService(UserService.class, true);
        User user = userService.getUser(guest.getGuestID(), context);
        if (Strings.isEmpty((String)user.getUserPassword()) && Strings.isEmpty((String)loginInfo.getPassword())) {
            return user;
        }
        if (!userService.authenticate(user, loginInfo.getPassword())) {
            GuestService guestService = ServerServiceRegistry.getInstance().getService(GuestService.class);
            if (guestService != null) {
                boolean authenticate = guestService.authenticate(user, context.getContextId(), loginInfo.getPassword());
                if (!authenticate) {
                    throw LoginExceptionCodes.INVALID_GUEST_PASSWORD.create();
                }
            } else {
                throw LoginExceptionCodes.INVALID_GUEST_PASSWORD.create();
            }
        }
        if (!loginInfo.getUsername().equals(user.getMail())) {
            throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
        }
        return user;
    }
}

