/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.ConfigMenu;
import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.Multiple;
import com.openexchange.ajax.SessionUtility;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.login.LoginClosure;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginCookiesSetter;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.ajax.writer.LoginWriter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.ResultCode;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.impl.ConfigTree;
import com.openexchange.groupware.settings.impl.SettingStorage;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.log.LogProperties;
import com.openexchange.login.LoginJsonEnhancer;
import com.openexchange.login.LoginRampUpService;
import com.openexchange.login.LoginResult;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.servlet.ratelimit.Key;
import com.openexchange.tools.servlet.ratelimit.RateLimitedException;
import com.openexchange.tools.servlet.ratelimit.RateLimiter;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoginRequestHandler
implements LoginRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLoginRequestHandler.class);
    private static final String USER_AGENT = "user-agent";
    private static volatile Integer maxLoginRate;
    private static volatile Integer maxLoginRateTimeWindow;
    private final Set<LoginRampUpService> rampUpServices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int maxLoginRate() {
        Integer tmp = maxLoginRate;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = maxLoginRate;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 50;
            }
            maxLoginRate = tmp = Integer.valueOf(service.getProperty("com.openexchange.ajax.login.maxRate", "50"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int maxLoginRateTimeWindow() {
        Integer tmp = maxLoginRateTimeWindow;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = maxLoginRateTimeWindow;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 300000;
            }
            maxLoginRateTimeWindow = tmp = Integer.valueOf(service.getProperty("com.openexchange.ajax.login.maxRateTimeWindow", "300000"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    protected AbstractLoginRequestHandler(Set<LoginRampUpService> rampUpServices) {
        this.rampUpServices = rampUpServices;
    }

    protected boolean loginOperation(HttpServletRequest req, HttpServletResponse resp, LoginClosure login, LoginConfiguration conf) throws IOException, OXException {
        return this.loginOperation(req, resp, login, null, conf);
    }

    protected boolean loginOperation(HttpServletRequest req, HttpServletResponse resp, LoginClosure login, LoginCookiesSetter cookiesSetter, LoginConfiguration conf) throws IOException, OXException {
        Session session;
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        Response response = new Response();
        LoginResult result = null;
        try {
            Throwable cause;
            String multipleRequest;
            int rate = AbstractLoginRequestHandler.maxLoginRate();
            int timeWindow = AbstractLoginRequestHandler.maxLoginRateTimeWindow();
            if (rate <= 0 || timeWindow <= 0) {
                result = login.doLogin(req);
                if (null == result) {
                    return true;
                }
            } else {
                Key rateLimitKey = new Key(req, req.getHeader(USER_AGENT), "__login.failed");
                boolean doubleRate = true;
                try {
                    boolean consumed = RateLimiter.optRateLimitFor(rateLimitKey, rate, timeWindow, req);
                    try {
                        result = login.doLogin(req);
                        if (null == result) {
                            return true;
                        }
                        RateLimiter.removeRateLimit(rateLimitKey);
                    }
                    catch (OXException e) {
                        if (!consumed && LoginExceptionCodes.INVALID_CREDENTIALS.equals(e)) {
                            doubleRate = false;
                            RateLimiter.checkRateLimitFor(rateLimitKey, rate, timeWindow, req);
                        }
                        throw e;
                    }
                }
                catch (RateLimitedException rateLimitExceeded) {
                    if (doubleRate) {
                        RateLimiter.doubleRateLimitWindow(rateLimitKey);
                    }
                    throw rateLimitExceeded;
                }
            }
            session = result.getSession();
            LogProperties.putSessionProperties((Session)session);
            LoginServlet.addHeadersAndCookies(result, resp);
            ResultCode code = result.getCode();
            if (null != code) {
                switch (code) {
                    case FAILED: {
                        return true;
                    }
                    case REDIRECT: {
                        throw LoginExceptionCodes.REDIRECT.create(new Object[]{result.getRedirect()});
                    }
                }
            }
            Future<Object> optModules = this.getModulesAsync(session, req);
            session.setParameter(USER_AGENT, (Object)req.getHeader(USER_AGENT));
            ServerSession serverSession = ServerSessionAdapter.valueOf(session);
            Future<JSONObject> optRampUp = this.rampUpAsync(serverSession, req);
            JSONObject json = new JSONObject(12);
            LoginWriter.write(result, json);
            if (result instanceof LoginJsonEnhancer) {
                ((LoginJsonEnhancer)((Object)result)).enhanceJson(json);
            }
            if ((multipleRequest = req.getParameter("multiple")) != null) {
                JSONArray dataArray = new JSONArray(multipleRequest);
                if (dataArray.length() > 0) {
                    JSONArray responses = Multiple.perform(dataArray, req, serverSession);
                    json.put("multiple", (Object)responses);
                } else {
                    json.put("multiple", (Object)new JSONArray(0));
                }
            }
            if (null != optRampUp) {
                try {
                    JSONObject jsonObject = optRampUp.get();
                    for (Map.Entry entry : jsonObject.entrySet()) {
                        json.put((String)entry.getKey(), entry.getValue());
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{"Thread interrupted."});
                }
                catch (ExecutionException e) {
                    cause = e.getCause();
                    LOG.warn("Ramp-up information could not be added to login JSON response", cause);
                }
            }
            if (null != optModules) {
                try {
                    Object oModules = optModules.get();
                    if (null != oModules) {
                        json.put("modules", oModules);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{"Thread interrupted."});
                }
                catch (ExecutionException e) {
                    cause = e.getCause();
                    LOG.warn("Modules could not be added to login JSON response", cause);
                }
            }
            response.setData(json);
        }
        catch (OXException e) {
            if ("SVL".equals(e.getPrefix())) {
                throw e;
            }
            if (LoginExceptionCodes.NOT_SUPPORTED.equals(e)) {
                LOG.debug("", (Throwable)e);
                throw AjaxExceptionCodes.DISABLED_ACTION.create("autologin");
            }
            if (LoginExceptionCodes.REDIRECT.equals(e) || LoginExceptionCodes.AUTHENTICATION_DISABLED.equals(e) || LoginExceptionCodes.INVALID_CREDENTIALS.equals(e)) {
                LOG.debug("", (Throwable)e);
            } else {
                LOG.error("", (Throwable)e);
            }
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error("", (Throwable)oje);
            response.setException(oje);
        }
        try {
            if (response.hasError() || null == result) {
                Locale loc;
                String sLocale = req.getParameter("language");
                Locale locale = null == sLocale ? this.bestGuessLocale(result, req) : (null == (loc = LocaleTools.getLocale((String)sLocale)) ? this.bestGuessLocale(result, req) : loc);
                ResponseWriter.write(response, resp.getWriter(), locale);
                return false;
            }
            session = result.getSession();
            SessionUtility.rememberSession(req, new ServerSessionAdapter(session));
            if (null == cookiesSetter) {
                LoginServlet.writeSecretCookie(req, resp, session, session.getHash(), req.isSecure(), req.getServerName(), conf);
            } else {
                cookiesSetter.setLoginCookies(session, req, resp, conf);
            }
            if (req.getParameter("callback") != null && "login".equals(req.getParameter("action"))) {
                APIResponseRenderer.writeResponse(response, "login", req, resp);
            } else {
                ((JSONObject)response.getData()).write((Writer)resp.getWriter());
            }
        }
        catch (JSONException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            LOG.error("Error while writing response object.", (Throwable)e);
            LoginServlet.sendError(resp);
            return false;
        }
        return false;
    }

    protected void performRampUp(HttpServletRequest req, JSONObject json, ServerSession session) throws OXException, IOException {
        this.performRampUp(req, json, session, false);
    }

    protected void performRampUp(HttpServletRequest req, JSONObject json, ServerSession session, boolean force) throws OXException, IOException {
        Set<LoginRampUpService> rampUpServices;
        if (null != session && (force || Boolean.parseBoolean(req.getParameter("rampup"))) && (rampUpServices = this.rampUpServices) != null) {
            try {
                String client = session.getClient();
                String clientOverride = req.getParameter("rampUpFor");
                if (clientOverride != null) {
                    client = clientOverride;
                }
                for (LoginRampUpService rampUpService : rampUpServices) {
                    if (!rampUpService.contributesTo(client)) continue;
                    JSONObject contribution = rampUpService.getContribution(session, AJAXRequestDataTools.getInstance().parseRequest(req, false, false, session, ""));
                    json.put("rampup", (Object)contribution);
                    return;
                }
            }
            catch (JSONException e) {
                throw OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            }
        }
    }

    private Locale bestGuessLocale(LoginResult result, HttpServletRequest req) {
        User user;
        Locale locale = null == result ? Tools.getLocaleByAcceptLanguage(req, null) : (null == (user = result.getUser()) ? Tools.getLocaleByAcceptLanguage(req, null) : user.getLocale());
        return locale;
    }

    public Future<Object> getModulesAsync(final Session session, HttpServletRequest req) {
        String modules = "modules";
        if (!LoginServlet.parseBoolean(req.getParameter("modules"))) {
            return null;
        }
        final Logger logger = LOG;
        return ThreadPools.getThreadPool().submit((Task)new AbstractTask<Object>(){

            public Object call() throws Exception {
                try {
                    Setting setting = ConfigTree.getInstance().getSettingByPath("modules");
                    SettingStorage.getInstance(session).readValues(setting);
                    return ConfigMenu.convert2JS(setting);
                }
                catch (OXException e) {
                    logger.warn("Modules could not be added to login JSON response", (Throwable)e);
                }
                catch (JSONException e) {
                    logger.warn("Modules could not be added to login JSON response", (Throwable)e);
                }
                catch (Exception e) {
                    logger.warn("Modules could not be added to login JSON response", (Throwable)e);
                }
                return null;
            }
        });
    }

    public Future<JSONObject> rampUpAsync(final ServerSession serverSession, final HttpServletRequest req) {
        AbstractTask<JSONObject> task = new AbstractTask<JSONObject>(){

            public JSONObject call() throws OXException, IOException {
                JSONObject json = new JSONObject(8);
                AbstractLoginRequestHandler.this.performRampUp(req, json, serverSession);
                return json;
            }
        };
        return ThreadPools.getThreadPool().submit((Task)task);
    }
}

