/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.helper;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;

public final class BrowserDetector {
    private static final Cache<String, BrowserDetector> CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(2L, TimeUnit.HOURS).build();
    public static final String UNKNOWN = "unknown";
    public static final String MSIE = "MSIE";
    public static final String OPERA = "Opera";
    public static final String MOZILLA = "Mozilla";
    public static final String WINDOWS = "Windows";
    public static final String UNIX = "Unix";
    public static final String MACINTOSH = "Macintosh";
    private final String userAgent;
    private String browserName;
    private float browserVersion;
    private String browserPlatform;
    private boolean javascriptOK;
    private boolean cssOK;
    private boolean fileUploadOK;
    private boolean safari;

    public static BrowserDetector detectorFor(String userAgent) {
        if (null == userAgent) {
            return null;
        }
        BrowserDetector result = (BrowserDetector)CACHE.getIfPresent((Object)userAgent);
        if (result == null) {
            result = new BrowserDetector(userAgent);
            CACHE.put((Object)userAgent, (Object)result);
        }
        return result;
    }

    @Deprecated
    public BrowserDetector(String userAgent) {
        this.userAgent = userAgent;
        this.browserName = UNKNOWN;
        this.browserVersion = 0.0f;
        this.browserPlatform = UNKNOWN;
        this.parse();
    }

    public boolean nearlyEquals(BrowserDetector other) {
        if (!this.browserName.equals(other.browserName)) {
            return false;
        }
        if (!this.browserPlatform.equals(other.browserPlatform)) {
            return false;
        }
        return this.browserVersion == other.browserVersion;
    }

    public boolean isCssOK() {
        return this.cssOK;
    }

    public boolean isFileUploadOK() {
        return this.fileUploadOK;
    }

    public boolean isJavascriptOK() {
        return this.javascriptOK;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public String getBrowserPlatform() {
        return this.browserPlatform;
    }

    public float getBrowserVersion() {
        return this.browserVersion;
    }

    public String getUserAgentString() {
        return this.userAgent;
    }

    public boolean isMSIE() {
        return MSIE.equals(this.getBrowserName());
    }

    public boolean isSafari() {
        return this.safari;
    }

    public boolean isSafari5() {
        return this.safari && this.browserVersion >= 5.0f;
    }

    public boolean isWindows() {
        return WINDOWS.equals(this.getBrowserPlatform());
    }

    private void parse() {
        if (null == this.userAgent || this.userAgent.length() == 0) {
            return;
        }
        int versionStartIndex = this.userAgent.indexOf(47);
        if (versionStartIndex < 0) {
            this.browserName = this.userAgent;
            return;
        }
        int versionEndIndex = this.userAgent.indexOf(32, versionStartIndex);
        this.browserName = this.userAgent.substring(0, versionStartIndex);
        try {
            this.browserVersion = Float.parseFloat(versionEndIndex < 0 ? this.userAgent.substring(versionStartIndex + 1) : this.userAgent.substring(versionStartIndex + 1, versionEndIndex));
        }
        catch (NumberFormatException e) {
            this.browserVersion = 0.0f;
        }
        int index = -1;
        index = this.userAgent.indexOf(MSIE);
        if (index >= 0) {
            versionStartIndex = index + MSIE.length() + 1;
            versionEndIndex = this.userAgent.indexOf(59, versionStartIndex);
            this.browserName = MSIE;
            try {
                this.browserVersion = Float.parseFloat(this.userAgent.substring(versionStartIndex, versionEndIndex));
            }
            catch (NumberFormatException e) {
                this.browserVersion = 0.0f;
            }
        }
        if ((index = this.userAgent.indexOf(OPERA)) >= 0) {
            versionStartIndex = index + OPERA.length() + 1;
            versionEndIndex = this.userAgent.indexOf(32, versionStartIndex);
            this.browserName = OPERA;
            try {
                this.browserVersion = Float.parseFloat(this.userAgent.substring(versionStartIndex, versionEndIndex));
            }
            catch (NumberFormatException e) {
                this.browserVersion = 0.0f;
            }
        }
        if (this.userAgent.indexOf(WINDOWS) >= 0 || this.userAgent.indexOf("WinNT") >= 0 || this.userAgent.indexOf("Win98") >= 0 || this.userAgent.indexOf("Win95") >= 0) {
            this.browserPlatform = WINDOWS;
        }
        if (this.userAgent.indexOf("Mac") >= 0) {
            this.browserPlatform = MACINTOSH;
        }
        if (this.userAgent.indexOf("X11") >= 0) {
            this.browserPlatform = UNIX;
        }
        if (WINDOWS.equals(this.browserPlatform)) {
            if (this.browserName.equals(MOZILLA)) {
                if (this.browserVersion >= 3.0f) {
                    this.javascriptOK = true;
                    this.fileUploadOK = true;
                }
                if (this.browserVersion >= 4.0f) {
                    this.cssOK = true;
                }
            } else if (this.browserName.equals(MSIE)) {
                if (this.browserVersion >= 4.0f) {
                    this.javascriptOK = true;
                    this.fileUploadOK = true;
                    this.cssOK = true;
                }
            } else if (this.browserName.equals(OPERA) && this.browserVersion >= 3.0f) {
                this.javascriptOK = true;
                this.fileUploadOK = true;
                this.cssOK = true;
            }
        } else if (MACINTOSH.equals(this.browserPlatform)) {
            if (this.browserName.equals(MOZILLA)) {
                if (this.browserVersion >= 3.0f) {
                    this.javascriptOK = true;
                    this.fileUploadOK = true;
                }
                if (this.browserVersion >= 4.0f) {
                    this.cssOK = true;
                }
            } else if (this.browserName.equals(MSIE)) {
                if (this.browserVersion >= 4.0f) {
                    this.javascriptOK = true;
                    this.fileUploadOK = true;
                }
                if (this.browserVersion > 4.0f) {
                    this.cssOK = true;
                }
            }
        } else if (UNIX.equals(this.browserPlatform) && this.browserName.equals(MOZILLA)) {
            if (this.browserVersion >= 3.0f) {
                this.javascriptOK = true;
                this.fileUploadOK = true;
            }
            if (this.browserVersion >= 4.0f) {
                this.cssOK = true;
            }
        }
        if (this.userAgent.contains("Safari")) {
            this.safari = true;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128).append("User agent=").append(this.userAgent);
        sb.append("\nBrowser name=").append(this.browserName).append(", browser version=").append(this.browserVersion);
        sb.append(", browser platform=").append(this.browserPlatform);
        return sb.toString();
    }
}

