/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.URI;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AJAXUtility {
    private static final Logger LOG;
    private static final Tika TIKA;
    protected static final BitSet WWW_FORM_URL;
    protected static final BitSet WWW_FORM_URL_ANCHOR;
    private static final Pattern PATTERN_CONTROL;
    private static final Pattern PATTERN_DSLASH;
    private static final Pattern PATTERN_CRLF;
    private static final Pattern PATTERN_DSLASH2;
    private static final ConcurrentMap<String, URLCodec> URL_CODECS;

    private AJAXUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectMimeType(InputStream in) throws IOException {
        if (null == in) {
            return null;
        }
        try {
            String string = TIKA.detect(in);
            return string;
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    public static String sanitizeParam(String sInput) {
        int pos;
        if (Strings.isEmpty((String)sInput)) {
            return sInput;
        }
        String s = sInput;
        while ((pos = s.indexOf(37)) >= 0 && pos < s.length() - 1) {
            try {
                s = new URLCodec("UTF-8").decode(s);
            }
            catch (DecoderException e) {
                // empty catch block
                break;
            }
        }
        s = PATTERN_CONTROL.matcher(s).replaceAll("");
        s = StringEscapeUtils.escapeHtml((String)s);
        Pattern patternDslash = PATTERN_DSLASH;
        Matcher matcher = patternDslash.matcher(s);
        while (matcher.find()) {
            s = matcher.replaceAll("/");
            matcher = patternDslash.matcher(s);
        }
        return s;
    }

    public static String encodeUrl(String s, boolean forAnchor, boolean forLocation, String charsetName) {
        if (Strings.isEmpty((String)s)) {
            return s;
        }
        try {
            Charset charset;
            String prefix = null;
            String retval = PATTERN_CRLF.matcher(s).replaceAll("");
            String cs = Strings.isEmpty((String)charsetName) ? ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding) : charsetName;
            Charset charset2 = charset = Strings.isEmpty((String)cs) ? Charsets.UTF_8 : Charsets.forName((String)cs);
            if (forAnchor) {
                int pos;
                int n = pos = (retval = Charsets.toAsciiString((byte[])URLCodec.encodeUrl((BitSet)WWW_FORM_URL_ANCHOR, (byte[])retval.getBytes(charset)))).length() > 6 ? retval.indexOf("://") : -1;
                if (pos > 0) {
                    String tmp = Strings.toLowerCase((CharSequence)retval.substring(0, pos));
                    if ("https".equals(tmp)) {
                        prefix = "https://";
                        retval = retval.substring(pos + 3);
                    } else if ("http".equals(tmp)) {
                        prefix = "http://";
                        retval = retval.substring(pos + 3);
                    }
                }
            } else {
                retval = Charsets.toAsciiString((byte[])URLCodec.encodeUrl((BitSet)WWW_FORM_URL, (byte[])retval.getBytes(charset)));
            }
            retval = PATTERN_CRLF.matcher(retval).replaceAll("");
            Pattern dupSlashes = PATTERN_DSLASH;
            if (forLocation) {
                try {
                    java.net.URI uri = new java.net.URI(retval);
                    if (uri.isAbsolute() || null != uri.getScheme() || null != uri.getHost()) {
                        throw new IllegalArgumentException("Illegal Location value: " + s);
                    }
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Illegal Location value: " + s, e);
                }
                dupSlashes = PATTERN_DSLASH2;
            }
            Matcher matcher = dupSlashes.matcher(retval);
            while (matcher.find()) {
                retval = matcher.replaceAll("/");
                matcher = dupSlashes.matcher(retval);
            }
            return null == prefix ? retval : prefix + retval;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error("A runtime error occurred.", (Throwable)e);
            return s;
        }
    }

    public static String encodeUrl(String s, boolean forAnchor, boolean forLocation) {
        return AJAXUtility.encodeUrl(s, forAnchor, forLocation, null);
    }

    public static String encodeUrl(String s, boolean forAnchor) {
        return AJAXUtility.encodeUrl(s, forAnchor, false);
    }

    public static String encodeUrl(String s) {
        return AJAXUtility.encodeUrl(s, false);
    }

    private static URLCodec getUrlCodec(String charset) {
        URLCodec nc;
        URLCodec urlCodec;
        String cs = charset;
        if (null == cs) {
            String defCharset = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding);
            if (null == defCharset) {
                return null;
            }
            cs = defCharset;
        }
        if (null == (urlCodec = (URLCodec)URL_CODECS.get(cs)) && null == (urlCodec = URL_CODECS.putIfAbsent(cs, nc = new URLCodec(cs)))) {
            urlCodec = nc;
        }
        return urlCodec;
    }

    public static String decodeUrl(String s, String charset) {
        try {
            if (Strings.isEmpty((String)s)) {
                return s;
            }
            String cs = Strings.isEmpty((String)charset) ? ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding) : charset;
            return AJAXUtility.getUrlCodec(cs).decode(s, cs);
        }
        catch (DecoderException e) {
            return s;
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static PrintWriter getWriter(HttpServletResponse resp, boolean tryFallBack) throws IOException {
        if (null == resp) {
            return null;
        }
        try {
            return resp.getWriter();
        }
        catch (IllegalStateException e) {
            if (tryFallBack) {
                try {
                    String charenc = resp.getCharacterEncoding();
                    if (Strings.isEmpty((String)charenc) && Strings.isEmpty((String)(charenc = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding)))) {
                        charenc = "UTF-8";
                    }
                    return new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), charenc), false);
                }
                catch (Exception x) {
                    LOG.warn("Unable to acquire Writer instance from HTTP response.", (Throwable)x);
                }
            } else {
                LOG.warn("Unable to acquire Writer instance from HTTP response.", (Throwable)e);
            }
            return null;
        }
    }

    static {
        int i;
        LOG = LoggerFactory.getLogger(AJAXUtility.class);
        TIKA = new Tika(TikaConfig.getDefaultConfig());
        BitSet bitSet = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            bitSet.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            bitSet.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            bitSet.set(i);
        }
        bitSet.set(45);
        bitSet.set(95);
        bitSet.set(46);
        bitSet.set(42);
        bitSet.set(32);
        WWW_FORM_URL = bitSet;
        WWW_FORM_URL_ANCHOR = URIExtended.URI_REFERENCE;
        PATTERN_CONTROL = Pattern.compile("[\\x00-\\x1F\\x7F]");
        PATTERN_DSLASH = Pattern.compile("(?://+)");
        PATTERN_CRLF = Pattern.compile("\r?\n|\r|(?:%0[aA])?%0[dD]|%0[aA]");
        PATTERN_DSLASH2 = Pattern.compile("(?:/|%2[fF]){2,}");
        URL_CODECS = new ConcurrentHashMap<String, URLCodec>(8, 0.9f, 1);
    }

    private static final class URIExtended
    extends URI {
        public static BitSet URI_REFERENCE = URI_reference;

        private URIExtended() {
        }
    }
}

