/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user;

import com.openexchange.user.AbstractUserServiceInterceptor;
import com.openexchange.user.UserServiceInterceptor;
import com.openexchange.user.UserServiceInterceptorRegistry;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserServiceInterceptorRegistryTest {
    private UserServiceInterceptorRegistry interceptorRegistry;
    private UserServiceInterceptor lowest;
    private UserServiceInterceptor middle;
    private UserServiceInterceptor highest;

    @Before
    public void before() {
        this.interceptorRegistry = new UserServiceInterceptorRegistry(null);
        this.lowest = new AbstractUserServiceInterceptor(){

            public int getRanking() {
                return -1;
            }
        };
        this.middle = new AbstractUserServiceInterceptor(){

            public int getRanking() {
                return 50;
            }
        };
        this.highest = new AbstractUserServiceInterceptor(){

            public int getRanking() {
                return 100;
            }
        };
    }

    @Test
    public void testRanking() throws Exception {
        this.interceptorRegistry.addInterceptor(this.highest);
        this.interceptorRegistry.addInterceptor(this.middle);
        this.interceptorRegistry.addInterceptor(this.lowest);
        this.assertOrder();
        this.clearRegistry();
        this.interceptorRegistry.addInterceptor(this.lowest);
        this.interceptorRegistry.addInterceptor(this.middle);
        this.interceptorRegistry.addInterceptor(this.highest);
        this.assertOrder();
        this.clearRegistry();
        this.interceptorRegistry.addInterceptor(this.middle);
        this.interceptorRegistry.addInterceptor(this.lowest);
        this.interceptorRegistry.addInterceptor(this.highest);
        this.assertOrder();
    }

    private void assertOrder() {
        List interceptors = this.interceptorRegistry.getInterceptors();
        Assert.assertEquals((String)"Wrong size", (long)3L, (long)interceptors.size());
        Iterator it = interceptors.iterator();
        Assert.assertTrue((String)"Wrong order", (it.next() == this.highest ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrong order", (it.next() == this.middle ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrong order", (it.next() == this.lowest ? 1 : 0) != 0);
    }

    private void clearRegistry() {
        this.interceptorRegistry.removeInterceptor(this.highest);
        this.interceptorRegistry.removeInterceptor(this.middle);
        this.interceptorRegistry.removeInterceptor(this.lowest);
    }
}

