/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.contact.ContactService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactUtil;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.mail.utils.MsisdnUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UserStorage.class, ServerServiceRegistry.class, ContactUtil.class})
public class MsisdnUtilityTest {
    @Mock
    private Session mockedSession;
    @Mock
    private User mockedUser;
    @Mock
    private ServerServiceRegistry serverServiceRegistry;
    @Mock
    private ContactService contactService;
    Set<String> numbers = new TreeSet<String>();
    Contact contact = new Contact();

    @Before
    public void setUp() throws OXException {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(UserStorage.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(ServerServiceRegistry.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(ContactUtil.class, (Class[])new Class[0]);
        PowerMockito.when((Object)this.mockedSession.getUserId()).thenReturn((Object)1);
        PowerMockito.when((Object)this.mockedSession.getContextId()).thenReturn((Object)1);
        PowerMockito.when((Object)this.mockedUser.getContactId()).thenReturn((Object)1);
        PowerMockito.when((Object)this.serverServiceRegistry.getService(ContactService.class)).thenReturn((Object)this.contactService);
        PowerMockito.when((Object)this.contactService.getContact(this.mockedSession, Integer.toString(6), Integer.toString(1))).thenReturn((Object)this.contact);
        PowerMockito.when((Object)this.contactService.getUser(this.mockedSession, 1)).thenReturn((Object)this.contact);
        PowerMockito.when((Object)UserStorage.getStorageUser((int)1, (int)1)).thenReturn((Object)this.mockedUser);
        PowerMockito.when((Object)ServerServiceRegistry.getInstance()).thenReturn((Object)this.serverServiceRegistry);
        PowerMockito.when((Object)ContactUtil.gatherTelephoneNumbers((Contact)this.contact)).thenReturn(this.numbers);
    }

    @Test
    public final void testAddMsisdnAddress_noNumberFound_returnWithoutAddedNumber() {
        HashSet validAddrs = new HashSet();
        MsisdnUtility.addMsisdnAddress(validAddrs, (Session)this.mockedSession);
        Assert.assertEquals((long)this.numbers.size(), (long)validAddrs.size());
    }

    @Test
    public final void testAddMsisdnAddress_oneNumberFound_returnWithAddedNumber() {
        this.numbers.add("myNumber");
        HashSet validAddrs = new HashSet();
        MsisdnUtility.addMsisdnAddress(validAddrs, (Session)this.mockedSession);
        Assert.assertEquals((long)this.numbers.size(), (long)validAddrs.size());
    }

    @Test
    public final void testAddMsisdnAddress_fiveNumberFound_returnWithAddedNumber() {
        this.numbers.add("myNumber0");
        this.numbers.add("myNumber1");
        this.numbers.add("myNumber2");
        this.numbers.add("myNumber3");
        this.numbers.add("myNumber4");
        HashSet validAddrs = new HashSet();
        MsisdnUtility.addMsisdnAddress(validAddrs, (Session)this.mockedSession);
        Assert.assertEquals((long)this.numbers.size(), (long)validAddrs.size());
    }

    @Test
    public final void testAddMsisdnAddress_noContactFound_return() {
        PowerMockito.when((Object)this.mockedUser.getContactId()).thenReturn((Object)0);
        HashSet validAddrs = new HashSet();
        MsisdnUtility.addMsisdnAddress(validAddrs, (Session)this.mockedSession);
        Assert.assertEquals((long)0L, (long)validAddrs.size());
    }

    @Test
    public final void testAddMsisdnAddress_contactServiceNull_return() {
        PowerMockito.when((Object)this.serverServiceRegistry.getService(ContactService.class)).thenReturn(null);
        HashSet validAddrs = new HashSet();
        MsisdnUtility.addMsisdnAddress(validAddrs, (Session)this.mockedSession);
        Assert.assertEquals((long)0L, (long)validAddrs.size());
    }

    @Test
    public final void testAddMsisdnAddress_contactNull_return() throws OXException {
        PowerMockito.when((Object)this.contactService.getContact(this.mockedSession, Integer.toString(6), Integer.toString(1))).thenReturn(null);
        HashSet validAddrs = new HashSet();
        MsisdnUtility.addMsisdnAddress(validAddrs, (Session)this.mockedSession);
        Assert.assertEquals((long)0L, (long)validAddrs.size());
    }
}

