/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import javax.mail.internet.InternetAddress;
import junit.framework.TestCase;

public class QuotedInternetAddressTest
extends TestCase {
    public void testBug33552() throws Exception {
        String s = "Foo \u00e0 Bar <foo@bar.info>, =?UTF-8?Q?Foo_=C3=A0_Bar_=3Cfoo=40bar=2Einfo=3E?=, \"Foo, Bar\" <foo@bar.info>";
        InternetAddress[] parsed = QuotedInternetAddress.parse((String)s);
        QuotedInternetAddressTest.assertEquals((String)"Display name does not equals \"Foo \u00e0 Bar\"", (String)"Foo \u00e0 Bar", (String)parsed[0].getPersonal());
        QuotedInternetAddressTest.assertEquals((String)"Address does not equals \"foo@bar.info\"", (String)"foo@bar.info", (String)parsed[0].getAddress());
        QuotedInternetAddressTest.assertEquals((String)"Display name does not equals \"Foo \u00e0 Bar\"", (String)"Foo \u00e0 Bar", (String)parsed[1].getPersonal());
        QuotedInternetAddressTest.assertEquals((String)"Address does not equals \"foo@bar.info\"", (String)"foo@bar.info", (String)parsed[1].getAddress());
        QuotedInternetAddressTest.assertEquals((String)"Display name does not equals \"Foo, Bar\"", (String)"Foo, Bar", (String)parsed[2].getPersonal());
        QuotedInternetAddressTest.assertEquals((String)"Address does not equals \"foo@bar.info\"", (String)"foo@bar.info", (String)parsed[2].getAddress());
    }

    public void testBug33305() throws Exception {
        QuotedInternetAddress a = new QuotedInternetAddress("\u00d6tt\u00f6 <stark@wie-die-wutz.de>");
        QuotedInternetAddressTest.assertEquals((String)"Unexpected personal", (String)"\u00d6tt\u00f6", (String)a.getPersonal());
        QuotedInternetAddressTest.assertEquals((String)"Unexpected mail-safe form", (String)"=?UTF-8?B?w5Z0dMO2?= <stark@wie-die-wutz.de>", (String)a.toString());
        QuotedInternetAddressTest.assertEquals((String)"Unexpected unicode form", (String)"\u00d6tt\u00f6 <stark@wie-die-wutz.de>", (String)a.toUnicodeString());
        InternetAddress[] parsed = QuotedInternetAddress.parse((String)"\u00d6tt\u00f6 <stark@wie-die-wutz.de>, Foo \u00e0 Bar <foo@bar.info>");
        QuotedInternetAddressTest.assertEquals((String)"Unexpected personal", (String)"\u00d6tt\u00f6", (String)parsed[0].getPersonal());
        QuotedInternetAddressTest.assertEquals((String)"Unexpected mail-safe form", (String)"=?UTF-8?B?w5Z0dMO2?= <stark@wie-die-wutz.de>", (String)parsed[0].toString());
        QuotedInternetAddressTest.assertEquals((String)"Unexpected unicode form", (String)"\u00d6tt\u00f6 <stark@wie-die-wutz.de>", (String)parsed[0].toUnicodeString());
        QuotedInternetAddressTest.assertEquals((String)"Unexpected personal", (String)"Foo \u00e0 Bar", (String)parsed[1].getPersonal());
        QuotedInternetAddressTest.assertEquals((String)"Unexpected mail-safe form", (String)"=?UTF-8?Q?Foo_=C3=A0_Bar?= <foo@bar.info>", (String)parsed[1].toString());
        QuotedInternetAddressTest.assertEquals((String)"Unexpected unicode form", (String)"Foo \u00e0 Bar <foo@bar.info>", (String)parsed[1].toUnicodeString());
    }

    public void testBug34070() throws Exception {
        String s = "=?windows-1252?Q?Betz=2C_C=E4cilia?= <caecilia.betz@invalid.org>";
        QuotedInternetAddress addr = new QuotedInternetAddress(s);
        QuotedInternetAddressTest.assertEquals((String)"Display name does not match \"Betz, C\u00e4cilia\"", (String)"Betz, C\u00e4cilia", (String)addr.getPersonal());
        QuotedInternetAddressTest.assertEquals((String)"Address does not match \"caecilia.betz@open-xchange.com\"", (String)"caecilia.betz@invalid.org", (String)addr.getAddress());
    }

    public void testBug34755() throws Exception {
        String s = "=?windows-1252?Q?Kr=F6ning=2C_User?= <user4@ox.microdoc.de>";
        QuotedInternetAddress addr = new QuotedInternetAddress(s);
        QuotedInternetAddressTest.assertEquals((String)"Display name does not match \"Kr\u00f6ning, User\"", (String)"Kr\u00f6ning, User", (String)addr.getPersonal());
        QuotedInternetAddressTest.assertEquals((String)"Address does not match \"user4@ox.microdoc.de\"", (String)"user4@ox.microdoc.de", (String)addr.getAddress());
    }

    public void testBug36095() throws Exception {
        String s = "=?UTF-8?Q?F=C3=B6oooo=2C_Bar?= <s.foeoooobar@foobar.org>";
        InternetAddress[] parsed = MimeMessageConverter.getAddressHeader((String)s);
        QuotedInternetAddressTest.assertEquals((String)"Unexpected amount of addresses", (int)1, (int)parsed.length);
        QuotedInternetAddressTest.assertEquals((String)"Display name does not equals \"F\u00f6oooo, Bar\"", (String)"F\u00f6oooo, Bar", (String)parsed[0].getPersonal());
        QuotedInternetAddressTest.assertEquals((String)"Address does not equals \"s.foeoooobar@foobar.org\"", (String)"s.foeoooobar@foobar.org", (String)parsed[0].getAddress());
    }

    public void testBug36866() throws Exception {
        String s = "=?iso-8859-1?Q?Mustermann=2C_J=F6rg?= <Joerg.Mustermann@musterfirma.org>";
        InternetAddress[] parsed = QuotedInternetAddress.parseHeader((String)s, (boolean)true);
        QuotedInternetAddressTest.assertEquals((String)"Unexpected amount of addresses", (int)1, (int)parsed.length);
        QuotedInternetAddressTest.assertEquals((String)"Display name does not equals \"Mustermann, J\u00f6rg\"", (String)"Mustermann, J\u00f6rg", (String)parsed[0].getPersonal());
        QuotedInternetAddressTest.assertEquals((String)"Address does not equals \"Joerg.Mustermann@musterfirma.org\"", (String)"Joerg.Mustermann@musterfirma.org", (String)parsed[0].getAddress());
    }

    public void testBug38365() throws Exception {
        QuotedInternetAddress addr = new QuotedInternetAddress("\"Peter \\\" Lustig\" <bar@foo.org>");
        QuotedInternetAddressTest.assertEquals((String)"Display name does not equals \"Peter \" Lustig\"", (String)"Peter \" Lustig", (String)addr.getPersonal());
        addr = new QuotedInternetAddress("bar@foo.org", "Peter Lustig \\");
        QuotedInternetAddressTest.assertEquals((String)"Display name does not equals \"Peter Lustig \\\"", (String)"Peter Lustig \\", (String)addr.getPersonal());
    }

    public void testBug43709() throws Exception {
        String addresses = "\"pere6@20101027.de\" <pere6@20101027.de>, =?iso-8859-1?Q?'Jochum=2C_Christel;_Sch=F6ndorf=2C_Werner'?= <boeser.recipient@example.com>, \"pere20@20101027.de\" <pere20@20101027.de>";
        InternetAddress[] addrs = QuotedInternetAddress.parseHeader((String)addresses, (boolean)true);
        QuotedInternetAddressTest.assertNotNull((String)"Unexpected parse result", (Object)addrs);
        QuotedInternetAddressTest.assertEquals((String)"Unexpected number of addresses", (int)3, (int)addrs.length);
        QuotedInternetAddressTest.assertEquals((String)"Unexpected personal", (String)"pere6@20101027.de", (String)addrs[0].getPersonal());
        QuotedInternetAddressTest.assertEquals((String)"Unexpected address", (String)"pere6@20101027.de", (String)addrs[0].getAddress());
        QuotedInternetAddressTest.assertEquals((String)"Unexpected personal", (String)"Jochum, Christel; Sch\u00f6ndorf, Werner", (String)addrs[1].getPersonal());
        QuotedInternetAddressTest.assertEquals((String)"Unexpected address", (String)"boeser.recipient@example.com", (String)addrs[1].getAddress());
    }
}

