/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.SimContext;
import com.openexchange.groupware.ldap.CachingUserStorage;
import com.openexchange.groupware.ldap.RdbUserStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServerServiceRegistry.class})
public class Bug33891Test {
    CacheKey mockedCacheKey;
    Cache mockedCache;
    CacheService mockedCacheService;
    ServerServiceRegistry mockedServiceRegistry;
    private RdbUserStorage mockedUserStorage;
    private CachingUserStorage cachingUserStorage;
    private User mockedUser;

    @Before
    public void setUp() throws OXException {
        this.mockedCacheKey = (CacheKey)Mockito.mock(CacheKey.class);
        ((CacheKey)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) {
                return 1;
            }
        }).when((Object)this.mockedCacheKey)).getContextId();
        ((CacheKey)Mockito.doAnswer((Answer)new Answer<String[]>(){

            public String[] answer(InvocationOnMock invocation) {
                return new String[]{String.valueOf(1)};
            }
        }).when((Object)this.mockedCacheKey)).getKeys();
        this.mockedCache = (Cache)Mockito.mock(Cache.class);
        ((Cache)Mockito.doAnswer((Answer)new Answer<CacheKey>(){

            public CacheKey answer(InvocationOnMock invocation) {
                return Bug33891Test.this.mockedCacheKey;
            }
        }).when((Object)this.mockedCache)).newCacheKey(1, 1);
        ((Cache)Mockito.doAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocation) {
                UserImpl retval = new UserImpl();
                retval.setImapServer("oldValue");
                return retval;
            }
        }).when((Object)this.mockedCache)).get((Serializable)Matchers.any());
        this.mockedCacheService = (CacheService)Mockito.mock(CacheService.class);
        ((CacheService)Mockito.doAnswer((Answer)new Answer<Cache>(){

            public Cache answer(InvocationOnMock invocation) {
                return Bug33891Test.this.mockedCache;
            }
        }).when((Object)this.mockedCacheService)).getCache("User");
        PowerMockito.mockStatic(ServerServiceRegistry.class, (Class[])new Class[0]);
        this.mockedServiceRegistry = (ServerServiceRegistry)Mockito.mock(ServerServiceRegistry.class);
        PowerMockito.when((Object)ServerServiceRegistry.getInstance()).thenReturn((Object)this.mockedServiceRegistry);
        ((ServerServiceRegistry)Mockito.doAnswer((Answer)new Answer<CacheService>(){

            public CacheService answer(InvocationOnMock invocation) {
                return Bug33891Test.this.mockedCacheService;
            }
        }).when((Object)this.mockedServiceRegistry)).getService(CacheService.class);
        this.mockedUserStorage = (RdbUserStorage)Mockito.mock(RdbUserStorage.class);
        this.cachingUserStorage = new CachingUserStorage(this.mockedUserStorage);
        this.mockedUser = (User)Mockito.mock(User.class);
        ((User)Mockito.doAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) {
                return "newValue";
            }
        }).when((Object)this.mockedUser)).getImapServer();
    }

    @After
    public void tearDown() {
        this.cachingUserStorage = null;
        this.mockedUserStorage = null;
        this.mockedCacheService = null;
        this.mockedCache = null;
        this.mockedCacheKey = null;
    }

    @Test
    public void test() throws OXException {
        SimContext simContext = new SimContext(1);
        this.cachingUserStorage.updateUserInternal(null, this.mockedUser, (Context)simContext);
        ((RdbUserStorage)Mockito.verify((Object)this.mockedUserStorage)).updateUser(this.mockedUser, (Context)simContext);
    }
}

