/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish.json;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.json.FormContentParser;
import com.openexchange.exception.OXException;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationTarget;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.publish.json.EntityType;
import com.openexchange.publish.json.PublicationJSONErrorMessage;
import com.openexchange.publish.json.types.EntityMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PublicationParser {
    private final PublicationTargetDiscoveryService discovery;
    private final Map<String, EntityType> entityTypes = new EntityMap();

    public PublicationParser(PublicationTargetDiscoveryService discovery) {
        this.discovery = discovery;
    }

    public Publication parse(JSONObject object) throws JSONException, OXException, OXException {
        Publication publication = new Publication();
        if (object.has("id")) {
            publication.setId(object.getInt("id"));
        }
        if (object.has("entityModule")) {
            String module = object.getString("entityModule");
            publication.setModule(module);
            if (object.has("entity")) {
                JSONObject entityDefinition = object.getJSONObject("entity");
                EntityType entityType = this.entityTypes.get(module);
                if (entityType == null) {
                    throw PublicationJSONErrorMessage.UNKOWN_ENTITY_MODULE.create(module);
                }
                String entityId = entityType.toEntityID(entityDefinition);
                publication.setEntityId(entityId);
            }
        }
        if (object.has("target")) {
            String target = object.getString("target");
            PublicationTarget pubTarget = this.discovery.getTarget(target);
            if (null == pubTarget) {
                throw PublicationJSONErrorMessage.UNKNOWN_TARGET.create(target);
            }
            publication.setTarget(pubTarget);
            if (object.has(pubTarget.getId())) {
                publication.setConfiguration(FormContentParser.parse((JSONObject)object.getJSONObject(pubTarget.getId()), (DynamicFormDescription)pubTarget.getFormDescription()));
            }
        }
        if (object.has("enabled")) {
            publication.setEnabled(object.getBoolean("enabled"));
        }
        return publication;
    }

    public void registerEntityType(String type, EntityType entityType) {
        this.entityTypes.put(type, entityType);
    }
}

