/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.java.Autoboxing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeferredRegistryRegistration<R, P>
extends ServiceTracker {
    private static final Logger LOG = LoggerFactory.getLogger(DeferredRegistryRegistration.class);
    private R registry;
    private final Class<R> registryClass;
    private final P item;
    private final List<Class<?>> expectedServices;
    private final Map<Class<?>, PriorityQueue<ServiceEntry>> serviceMap = new ConcurrentHashMap();

    public DeferredRegistryRegistration(BundleContext context, Class<R> registryClass, P item, Class<?> ... additionalServices) {
        super(context, DeferredRegistryRegistration.buildFilter(context, registryClass, additionalServices), null);
        this.registryClass = registryClass;
        this.item = item;
        this.expectedServices = new ArrayList(1 + (additionalServices == null ? 0 : additionalServices.length));
        this.expectedServices.add(registryClass);
        if (additionalServices != null) {
            for (Class<?> serviceClass : additionalServices) {
                this.expectedServices.add(serviceClass);
            }
        }
    }

    private static Filter buildFilter(BundleContext context, Class<?> registryClass, Class<?>[] additionalServices) {
        try {
            if (additionalServices == null || additionalServices.length == 0) {
                return context.createFilter("(objectClass=" + registryClass.getName() + ")");
            }
            StringBuilder builder = new StringBuilder("(| (").append("objectClass").append('=').append(registryClass.getName()).append(')');
            for (Class<?> klass : additionalServices) {
                builder.append('(').append("objectClass").append('=').append(klass.getName()).append(')');
            }
            builder.append(')');
            return context.createFilter(builder.toString());
        }
        catch (InvalidSyntaxException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public abstract void register(R var1, P var2);

    public abstract void unregister(R var1, P var2);

    public void remove() {
        this.close();
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.remember(reference);
        if (this.isComplete()) {
            this.register(this.registry, this.item);
        }
        return service;
    }

    private Object remember(ServiceReference reference) {
        Object service = super.addingService(reference);
        for (Class<?> klass : this.expectedServices) {
            PriorityQueue<ServiceEntry> otherQueue;
            if (!klass.isInstance(service)) continue;
            PriorityQueue<ServiceEntry> priorityQueue = this.serviceMap.get(klass);
            if (priorityQueue == null && (otherQueue = this.serviceMap.put(klass, priorityQueue = new PriorityQueue())) != null) {
                priorityQueue = otherQueue;
            }
            priorityQueue.add(new ServiceEntry(reference, service));
        }
        if (this.registryClass.isInstance(service)) {
            this.registry = service;
        }
        return service;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.forget(service);
        if (!this.isComplete()) {
            this.unregister(this.registry, this.item);
        }
        if (service == this.registry) {
            this.registry = null;
        }
    }

    private void forget(Object service) {
        for (Class<?> klass : this.expectedServices) {
            PriorityQueue<ServiceEntry> priorityQueue;
            if (!klass.isInstance(service) || (priorityQueue = this.serviceMap.get(klass)) == null) continue;
            Iterator<ServiceEntry> iterator = priorityQueue.iterator();
            while (iterator.hasNext()) {
                ServiceEntry next = iterator.next();
                if (next.service != service) continue;
                iterator.remove();
            }
        }
    }

    private boolean isComplete() {
        for (Class<?> klass : this.expectedServices) {
            PriorityQueue<ServiceEntry> priorityQueue = this.serviceMap.get(klass);
            if (priorityQueue != null && !priorityQueue.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public <I> I getService(Class<I> klass) {
        PriorityQueue<ServiceEntry> priorityQueue = this.serviceMap.get(klass);
        if (priorityQueue == null || priorityQueue.isEmpty()) {
            return null;
        }
        return (I)priorityQueue.peek().service;
    }

    private final class ServiceEntry
    implements Comparable<ServiceEntry> {
        public ServiceReference ref;
        public Object service;

        public ServiceEntry(ServiceReference ref, Object service) {
            this.ref = ref;
            this.service = service;
        }

        @Override
        public int compareTo(ServiceEntry o) {
            return this.getPriority() - o.getPriority();
        }

        private int getPriority() {
            Object property = this.ref.getProperty("service.ranking");
            if (property == null) {
                return 0;
            }
            return Autoboxing.a2i((Object)property);
        }
    }
}

