/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.exception.OXException;
import com.openexchange.messaging.MessagingAccountAccess;
import com.openexchange.messaging.MessagingAccountManager;
import com.openexchange.messaging.MessagingAccountTransport;
import com.openexchange.messaging.MessagingAction;
import com.openexchange.messaging.MessagingService;
import com.openexchange.session.Session;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimMessagingService
implements MessagingService {
    private String displayName;
    private DynamicFormDescription formDescription;
    private String id;
    private final Map<Integer, MessagingAccountAccess> accountAccessMap = new HashMap<Integer, MessagingAccountAccess>();
    private final Map<Integer, MessagingAccountTransport> accountTransportMap = new HashMap<Integer, MessagingAccountTransport>();
    private MessagingAccountManager accManager;
    private List<MessagingAction> capabilities;
    private int[] staticRootPermissions;

    public Set<String> getSecretProperties() {
        return SimMessagingService.getPasswordElementNames(this.formDescription);
    }

    private static Set<String> getPasswordElementNames(DynamicFormDescription formDescription) {
        HashSet<String> retval = new HashSet<String>(2);
        for (FormElement formElement : formDescription) {
            if (!FormElement.Widget.PASSWORD.equals((Object)formElement.getWidget())) continue;
            retval.add(formElement.getName());
        }
        return retval;
    }

    public MessagingAccountManager getAccountManager() {
        return this.accManager;
    }

    public List<MessagingAction> getMessageActions() {
        return this.capabilities;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DynamicFormDescription getFormDescription() {
        return this.formDescription;
    }

    public String getId() {
        return this.id;
    }

    public void setMessageActions(List<MessagingAction> capabilities) {
        this.capabilities = capabilities;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setFormDescription(DynamicFormDescription formDescription) {
        this.formDescription = formDescription;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAccountManager(MessagingAccountManager accManager) {
        this.accManager = accManager;
    }

    public MessagingAccountAccess getAccountAccess(int accountId, Session session) throws OXException {
        MessagingAccountAccess accountAccess = this.accountAccessMap.get(accountId);
        if (null == accountAccess) {
            // empty if block
        }
        return accountAccess;
    }

    public void setAccountAccess(int accountId, MessagingAccountAccess accountAccess) {
        this.accountAccessMap.put(accountId, accountAccess);
    }

    public MessagingAccountTransport getAccountTransport(int accountId, Session session) throws OXException {
        MessagingAccountTransport accountTransport = this.accountTransportMap.get(accountId);
        if (null == accountTransport) {
            // empty if block
        }
        return accountTransport;
    }

    public void setAccountTransport(int accountId, MessagingAccountTransport accountTransport) {
        this.accountTransportMap.put(accountId, accountTransport);
    }

    public int[] getStaticRootPermissions() {
        if (null == this.staticRootPermissions) {
            return null;
        }
        int[] ret = new int[this.staticRootPermissions.length];
        System.arraycopy(this.staticRootPermissions, 0, ret, 0, ret.length);
        return ret;
    }

    public void setStaticRootPermissions(int[] staticRootPermissions) {
        if (null == staticRootPermissions) {
            this.staticRootPermissions = null;
        } else {
            int[] tmp = new int[staticRootPermissions.length];
            System.arraycopy(staticRootPermissions, 0, tmp, 0, tmp.length);
            this.staticRootPermissions = tmp;
        }
    }
}

