/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.jslob.internal;

import com.openexchange.exception.OXException;
import com.openexchange.jslob.storage.JSlobStorage;
import com.openexchange.jslob.storage.registry.JSlobStorageRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class JSlobStorageRegistryImpl
implements JSlobStorageRegistry {
    private static final JSlobStorageRegistryImpl INSTANCE = new JSlobStorageRegistryImpl();
    private final ConcurrentMap<String, JSlobStorage> registry = new ConcurrentHashMap<String, JSlobStorage>(2, 0.9f, 1);

    public static JSlobStorageRegistryImpl getInstance() {
        return INSTANCE;
    }

    private JSlobStorageRegistryImpl() {
    }

    @Override
    public JSlobStorage getJSlobStorage(String storageId) throws OXException {
        return (JSlobStorage)this.registry.get(storageId);
    }

    @Override
    public Collection<JSlobStorage> getJSlobStorages() throws OXException {
        ArrayList<JSlobStorage> list = new ArrayList<JSlobStorage>(8);
        list.addAll(this.registry.values());
        return list;
    }

    @Override
    public boolean putJSlobStorage(JSlobStorage jslobStorage) {
        return null == this.registry.putIfAbsent(jslobStorage.getIdentifier(), jslobStorage);
    }

    @Override
    public void removeJSlobStorage(String storageId) throws OXException {
        this.registry.remove(storageId);
    }
}

