/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java.util;

import com.openexchange.java.Strings;
import java.util.regex.Pattern;

public class MsisdnCheck {
    private static final Pattern PATTERN_VALIDATE = Pattern.compile("(^\\+[0-9]{2}|^\\+[0-9]{2}\\(0\\)|^\\(\\+[0-9]{2}\\)\\(0\\)|^00[0-9]{2}|^0)([0-9]{9}$|[0-9\\-\\s]{10}$)");
    private static final Pattern PATTERN_CLEANUP = Pattern.compile("[+()/ ]");

    private MsisdnCheck() {
    }

    public static boolean validate(String number) {
        if (Strings.isEmpty(number)) {
            return false;
        }
        return PATTERN_VALIDATE.matcher(number).matches();
    }

    public static boolean checkMsisdn(String number) {
        if (Strings.isEmpty(number)) {
            return false;
        }
        String num = number;
        int pos = num.indexOf(47);
        if (pos > 0) {
            num = num.substring(0, pos);
        }
        num = MsisdnCheck.cleanup(num);
        int len = num.length();
        boolean isDigit = true;
        for (int i = 0; isDigit && i < len; ++i) {
            isDigit = Strings.isDigit(num.charAt(i));
        }
        return isDigit;
    }

    public static String cleanup(String number) {
        return PATTERN_CLEANUP.matcher(number).replaceAll("");
    }
}

