/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.io.IOException;
import java.io.InputStream;

public class CombinedInputStream
extends InputStream {
    private final byte[] consumed;
    private final InputStream remaining;
    private int count;

    public CombinedInputStream(byte[] consumed, InputStream remaining) {
        if (null == consumed) {
            throw new IllegalArgumentException("Byte array is null.");
        }
        if (null == remaining) {
            throw new IllegalArgumentException("Input stream array is null.");
        }
        this.consumed = new byte[consumed.length];
        System.arraycopy(consumed, 0, this.consumed, 0, consumed.length);
        this.remaining = remaining;
        this.count = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.count < this.consumed.length) {
            return this.consumed[this.count++];
        }
        return this.remaining.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.count < this.consumed.length) {
            int buffered = this.consumed.length - this.count;
            if (buffered >= len) {
                int retval = buffered <= len ? buffered : len;
                System.arraycopy(this.consumed, this.count, b, off, retval);
                this.count += retval;
                return retval;
            }
            System.arraycopy(this.consumed, this.count, b, off, buffered);
            this.count += buffered;
            return buffered + this.remaining.read(b, off + buffered, len - buffered);
        }
        return this.remaining.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.remaining.close();
    }
}

