/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Streams;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CharsetDetector {
    private static final Logger LOG = LoggerFactory.getLogger(CharsetDetector.class);
    private static final String FALLBACK = "ISO-8859-1";

    private CharsetDetector() {
    }

    public static String getFallback() {
        return FALLBACK;
    }

    public static boolean isValid(String charset) {
        try {
            return null != charset && CharsetDetector.checkName(charset) && Charset.isSupported(charset);
        }
        catch (RuntimeException rte) {
            LOG.warn("RuntimeException while checking charset: {}", (Object)charset, (Object)rte);
            return false;
        }
        catch (Error e) {
            CharsetDetector.handleThrowable(e);
            LOG.warn("Error while checking charset: {}", (Object)charset, (Object)e);
            return false;
        }
        catch (Throwable t) {
            CharsetDetector.handleThrowable(t);
            LOG.warn("Unexpected error while checking charset: {}", (Object)charset, (Object)t);
            return false;
        }
    }

    private static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            LOG.error(" ---=== /!\\ ===--- Thread death ---=== /!\\ ===--- ", t);
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            LOG.error(" ---=== /!\\ ===--- The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating. ---=== /!\\ ===--- ", t);
            throw (VirtualMachineError)t;
        }
    }

    public static boolean checkName(String s) {
        if (s == null) {
            throw new NullPointerException("name is null");
        }
        int n = s.length();
        if (n == 0) {
            return false;
        }
        boolean legal = true;
        for (int i = 0; legal && i < n; ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == ':' || c == '_' || c == '.') continue;
            legal = false;
        }
        return legal;
    }

    public static String detectCharset(byte[] in) {
        return CharsetDetector.detectCharset(in, in.length);
    }

    public static String detectCharset(byte[] in, int len) {
        if (null == in) {
            throw new NullPointerException("byte array input stream is null");
        }
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(in, 0, len);
        detector.dataEnd();
        return CharsetDetector.getResultingCharset(detector);
    }

    public static String detectCharset(ByteArrayInputStream in) {
        return CharsetDetector.detectCharset((InputStream)in);
    }

    public static String detectCharset(InputStream in) {
        return CharsetDetector.detectCharset(in, CharsetDetector.getFallback(), true);
    }

    public static String detectCharset(InputStream in, String fallback, boolean close) {
        try {
            return CharsetDetector.detectCharsetFailOnError(in, fallback, close);
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            return FALLBACK;
        }
    }

    public static String detectCharsetFailOnError(InputStream in) throws IOException {
        return CharsetDetector.detectCharsetFailOnError(in, CharsetDetector.getFallback(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectCharsetFailOnError(InputStream in, String fallback, boolean close) throws IOException {
        if (null == in) {
            throw new NullPointerException("input stream is null");
        }
        UniversalDetector detector = new UniversalDetector(null);
        try {
            int read;
            byte[] buffer = new byte[4096];
            while (0 < (read = in.read(buffer)) && !detector.isDone()) {
                detector.handleData(buffer, 0, read);
            }
        }
        catch (IOException e) {
            LOG.warn("", (Throwable)e);
        }
        finally {
            if (close) {
                Streams.close((Closeable)in);
            }
        }
        detector.dataEnd();
        return CharsetDetector.getResultingCharset(detector, fallback);
    }

    private static String getResultingCharset(UniversalDetector detector) {
        String detectedCharset = detector.getDetectedCharset();
        if (null == detectedCharset || !CharsetDetector.isValid(detectedCharset)) {
            return FALLBACK;
        }
        return detectedCharset;
    }

    private static String getResultingCharset(UniversalDetector detector, String fallback) {
        String detectedCharset = detector.getDetectedCharset();
        if (null == detectedCharset || !CharsetDetector.isValid(detectedCharset)) {
            return fallback;
        }
        return detectedCharset;
    }
}

