/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class AsciiReader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final InputStream fInputStream;
    protected final byte[] fBuffer;
    protected boolean errorOnAsciiFault;

    public AsciiReader(InputStream inputStream) {
        this(inputStream, 2048);
        this.errorOnAsciiFault = false;
    }

    public AsciiReader(InputStream inputStream, int size) {
        this(inputStream, new byte[size]);
    }

    public AsciiReader(InputStream inputStream, byte[] buffer) {
        this.fInputStream = inputStream;
        this.fBuffer = buffer;
    }

    public AsciiReader setErrorOnAsciiFault(boolean errorOnAsciiFault) {
        this.errorOnAsciiFault = errorOnAsciiFault;
        return this;
    }

    @Override
    public int read() throws IOException {
        int b0 = this.fInputStream.read();
        if (this.errorOnAsciiFault && b0 >= 128) {
            throw new IOException("Invalid ASCII: " + Integer.toString(b0));
        }
        return b0;
    }

    @Override
    public int read(char[] ch, int offset, int length) throws IOException {
        if (length > this.fBuffer.length) {
            length = this.fBuffer.length;
        }
        int count = this.fInputStream.read(this.fBuffer, 0, length);
        for (int i = 0; i < count; ++i) {
            byte b0 = this.fBuffer[i];
            if (this.errorOnAsciiFault && b0 < 0) {
                throw new IOException("Invalid ASCII: " + Integer.toString(b0 & 0xFF));
            }
            ch[offset + i] = (char)b0;
        }
        return count;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.fInputStream.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return false;
    }

    @Override
    public boolean markSupported() {
        return this.fInputStream.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.fInputStream.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.fInputStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.fInputStream.close();
    }
}

