/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public class CountingInputStream
extends FilterInputStream {
    private static final IOExceptionCreator DEFAULT_EXCEPTION_CREATOR = new IOExceptionCreator(){

        @Override
        public IOException createIOException(long total, long max) {
            return new IOException(new StringBuilder(32).append("Max. byte count of ").append(max).append(" exceeded.").toString());
        }
    };
    private final AtomicLong count;
    private volatile long mark;
    private volatile long max;
    private final IOExceptionCreator exceptionCreator;

    public CountingInputStream(InputStream in, long max) {
        this(in, max, null);
    }

    public CountingInputStream(InputStream in, long max, IOExceptionCreator exceptionCreator) {
        super(in);
        this.max = max;
        this.count = new AtomicLong(0L);
        this.mark = -1L;
        this.exceptionCreator = null == exceptionCreator ? DEFAULT_EXCEPTION_CREATOR : exceptionCreator;
    }

    private void check(int consumed) throws IOException {
        long max = this.max;
        if (max > 0L) {
            if (this.count.addAndGet(consumed) > max) {
                throw this.exceptionCreator.createIOException(0L, max);
            }
        } else {
            this.count.addAndGet(consumed);
        }
    }

    public long resetByteCount() {
        long tmp = this.count.get();
        this.count.set(0L);
        return tmp;
    }

    public long getCount() {
        return this.count.get();
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        if (result < 0) {
            return result;
        }
        this.check(1);
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = super.read(b);
        if (result < 0) {
            return result;
        }
        this.check(result);
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result < 0) {
            return result;
        }
        this.check(result);
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.in.skip(n);
        long max = this.max;
        if (max > 0L) {
            this.max = max + n;
        }
        this.count.addAndGet(result);
        return result;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.count.get();
    }

    @Override
    public void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        long mark = this.mark;
        if (mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.count.set(mark);
    }

    public static interface IOExceptionCreator {
        public IOException createIOException(long var1, long var3);
    }
}

