/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.iterator;

import com.openexchange.exception.OXException;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class MergingSearchIterator<T>
implements SearchIterator<T> {
    private List<SearchIterator<T>> iterators = null;
    private Comparator<T> comparator;
    private List<T> topmost = null;
    private boolean ascending = true;
    private boolean hasNext;

    public MergingSearchIterator(Comparator<T> criterion, boolean ascending, SearchIterator<T> ... iterators) throws OXException {
        this(criterion, ascending, Arrays.asList(iterators));
    }

    public MergingSearchIterator(Comparator<T> criterion, boolean ascending, List<SearchIterator<T>> iterators) throws OXException {
        this.iterators = iterators;
        this.topmost = new ArrayList<T>(iterators.size());
        for (SearchIterator<T> iterator : iterators) {
            if (iterator.hasNext()) {
                this.topmost.add(iterator.next());
                this.hasNext = true;
                continue;
            }
            this.topmost.add(null);
        }
        this.comparator = criterion;
        this.ascending = ascending;
    }

    @Override
    public void addWarning(OXException warning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        for (SearchIterator<T> iterator : this.iterators) {
            SearchIterators.close(iterator);
        }
    }

    @Override
    public OXException[] getWarnings() {
        ArrayList<OXException> exceptions = new ArrayList<OXException>(10);
        for (SearchIterator<T> iterator : this.iterators) {
            OXException[] warnings;
            if (!iterator.hasWarnings() || (warnings = iterator.getWarnings()) == null) continue;
            exceptions.addAll(Arrays.asList(warnings));
        }
        return exceptions.toArray(new OXException[exceptions.size()]);
    }

    @Override
    public boolean hasNext() throws OXException {
        return this.hasNext;
    }

    @Override
    public boolean hasWarnings() {
        for (SearchIterator<T> iterator : this.iterators) {
            if (!iterator.hasWarnings()) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() throws OXException {
        if (!this.hasNext) {
            return null;
        }
        T largest = null;
        int i = -1;
        int largestIndex = 0;
        int direction = this.ascending ? 1 : -1;
        for (T candidate : this.topmost) {
            ++i;
            if (candidate == null || largest != null && 0 <= direction * this.comparator.compare(largest, candidate)) continue;
            largest = candidate;
            largestIndex = i;
        }
        if (this.iterators.get(largestIndex).hasNext()) {
            this.topmost.set(largestIndex, this.iterators.get(largestIndex).next());
        } else {
            this.topmost.set(largestIndex, null);
        }
        this.hasNext = false;
        for (T thing : this.topmost) {
            if (thing == null) continue;
            this.hasNext = true;
        }
        return largest;
    }

    @Override
    public int size() {
        int size = 0;
        for (SearchIterator<T> iterator : this.iterators) {
            int s = iterator.size();
            if (s == -1) {
                return -1;
            }
            size += s;
        }
        return size;
    }
}

