/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.startup.impl;

import com.openexchange.java.Streams;
import com.openexchange.startup.CloseableControlService;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThreadLocalCloseableControl
implements CloseableControlService {
    private static final ThreadLocalCloseableControl INSTANCE = new ThreadLocalCloseableControl();
    final ThreadLocal<Queue<Closeable>> closeables = new ThreadLocal();

    public static ThreadLocalCloseableControl getInstance() {
        return INSTANCE;
    }

    private ThreadLocalCloseableControl() {
    }

    @Override
    public boolean addCloseable(Closeable closeable) {
        if (null == closeable) {
            return false;
        }
        Queue<Closeable> queue = this.closeables.get();
        if (null == queue) {
            ConcurrentLinkedQueue<Closeable> nq = new ConcurrentLinkedQueue<Closeable>();
            this.closeables.set(nq);
            queue = nq;
        }
        return queue.offer(closeable);
    }

    @Override
    public boolean removeCloseable(Closeable closeable) {
        if (null == closeable) {
            return false;
        }
        Queue<Closeable> queue = this.closeables.get();
        if (null == queue) {
            return false;
        }
        return queue.remove(closeable);
    }

    @Override
    public Collection<Closeable> getCurrentCloseables() {
        Queue<Closeable> queue = this.closeables.get();
        return null == queue ? Collections.emptyList() : Collections.unmodifiableCollection(queue);
    }

    @Override
    public void closeAll() {
        Queue<Closeable> queue = this.closeables.get();
        if (null != queue) {
            Closeable closeable;
            while ((closeable = queue.poll()) != null) {
                Streams.close((Closeable)closeable);
            }
        }
    }
}

