/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.startup.impl;

import com.openexchange.startup.ThreadControlService;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ThreadControl
implements ThreadControlService {
    private static final Object PRESENT = new Object();
    private static final ThreadControlService INSTANCE = new ThreadControl();
    private final ConcurrentMap<Thread, Object> threads = new ConcurrentHashMap<Thread, Object>(256, 0.9f, 1);

    public static ThreadControlService getInstance() {
        return INSTANCE;
    }

    private ThreadControl() {
    }

    @Override
    public boolean addThread(Thread thread) {
        if (null == thread) {
            return false;
        }
        return null == this.threads.putIfAbsent(thread, PRESENT);
    }

    @Override
    public boolean removeThread(Thread thread) {
        if (null == thread) {
            return false;
        }
        return null != this.threads.remove(thread);
    }

    @Override
    public Collection<Thread> getCurrentThreads() {
        return Collections.unmodifiableCollection(this.threads.keySet());
    }

    @Override
    public void interruptAll() {
        for (Thread thread : this.threads.keySet()) {
            this.interruptSafe(thread);
        }
    }

    private void interruptSafe(Thread thread) {
        try {
            thread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

