/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.session.inspector.internal;

import com.openexchange.exception.OXException;
import com.openexchange.session.Reply;
import com.openexchange.session.Session;
import com.openexchange.session.inspector.Reason;
import com.openexchange.session.inspector.SessionInspectorChain;
import com.openexchange.session.inspector.SessionInspectorService;
import com.openexchange.session.inspector.internal.ServiceSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionInspectorChainImpl
implements SessionInspectorChain {
    private final ServiceSet<SessionInspectorService> chain;

    public SessionInspectorChainImpl(ServiceSet<SessionInspectorService> chain) {
        this.chain = chain;
    }

    @Override
    public boolean isEmpty() {
        return this.chain.isEmpty();
    }

    @Override
    public Reply onSessionHit(Session session, HttpServletRequest request, HttpServletResponse response) throws OXException {
        for (SessionInspectorService inspector : this.chain) {
            Reply r = inspector.onSessionHit(session, request, response);
            if (r == Reply.NEUTRAL) continue;
            return r;
        }
        return Reply.NEUTRAL;
    }

    @Override
    public Reply onSessionMiss(String sessionId, HttpServletRequest request, HttpServletResponse response) throws OXException {
        for (SessionInspectorService inspector : this.chain) {
            Reply r = inspector.onSessionMiss(sessionId, request, response);
            if (r == Reply.NEUTRAL) continue;
            return r;
        }
        return Reply.NEUTRAL;
    }

    @Override
    public Reply onAutoLoginFailed(Reason reason, HttpServletRequest request, HttpServletResponse response) throws OXException {
        for (SessionInspectorService inspector : this.chain) {
            Reply r = inspector.onAutoLoginFailed(reason, request, response);
            if (r == Reply.NEUTRAL) continue;
            return r;
        }
        return Reply.NEUTRAL;
    }
}

