/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.passwordmechs;

import com.openexchange.java.Strings;
import com.openexchange.passwordmechs.IPasswordMech;
import com.openexchange.passwordmechs.PasswordMechFactory;
import java.util.HashMap;
import java.util.Map;

public class PasswordMechFactoryImpl
implements PasswordMechFactory {
    private final Map<String, IPasswordMech> registeredPasswordMechs = new HashMap<String, IPasswordMech>();

    @Override
    public void register(IPasswordMech ... passwordMech) {
        for (IPasswordMech mech : passwordMech) {
            String id = this.adaptIdentifier(mech.getIdentifier());
            this.registeredPasswordMechs.put(id, mech);
        }
    }

    @Override
    public IPasswordMech get(String identifier) {
        String id = this.adaptIdentifier(identifier);
        return this.registeredPasswordMechs.get(id);
    }

    private String adaptIdentifier(String identifier) {
        String id = Strings.toUpperCase((CharSequence)identifier);
        if (!id.startsWith("{")) {
            id = new StringBuilder(id.length() + 1).append('{').append(id).toString();
        }
        if (!id.endsWith("}")) {
            id = new StringBuilder(id.length() + 1).append(id).append('}').toString();
        }
        return id;
    }
}

