/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.results;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.results.Delta;
import com.openexchange.tools.iterator.CombinedSearchIterator;
import com.openexchange.tools.iterator.SearchIterator;

public class DeltaImpl<T>
implements Delta<T> {
    private final SearchIterator<T> newOnes;
    private final SearchIterator<T> modifiedOnes;
    private final SearchIterator<T> deletedOnes;
    private final long sequenceNumber;

    public DeltaImpl(SearchIterator<T> newOnes, SearchIterator<T> modifiedOnes, SearchIterator<T> deletedOnes, long sequenceNumber) {
        this.newOnes = newOnes;
        this.modifiedOnes = modifiedOnes;
        this.deletedOnes = deletedOnes;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public SearchIterator<T> getNew() {
        return this.newOnes;
    }

    @Override
    public SearchIterator<T> getModified() {
        return this.modifiedOnes;
    }

    @Override
    public SearchIterator<T> getDeleted() {
        return this.deletedOnes;
    }

    @Override
    public SearchIterator<T> results() throws OXException {
        return new CombinedSearchIterator(this.newOnes, this.modifiedOnes);
    }

    @Override
    public long sequenceNumber() throws OXException {
        return this.sequenceNumber;
    }

    public void close() throws OXException {
        this.newOnes.close();
        this.modifiedOnes.close();
        this.deletedOnes.close();
    }
}

