/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cli;

import com.openexchange.auth.rmi.RemoteAuthenticator;
import com.openexchange.cli.AbstractAdministrativeCLI;
import com.openexchange.cli.ExecutionFault;
import com.openexchange.java.Strings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public abstract class AbstractRmiCLI<R>
extends AbstractAdministrativeCLI<R, String> {
    protected static final AtomicReference<String> RMI_HOSTNAME = new AtomicReference<String>("rmi://localhost:1099/");

    protected static void setRMI_HOSTNAME(String rmiHostName) {
        String host = rmiHostName;
        if (!host.startsWith("rmi://")) {
            host = "rmi://" + host;
        }
        if (!host.endsWith("/")) {
            host = host + "/";
        }
        RMI_HOSTNAME.set(host);
    }

    protected AbstractRmiCLI() {
        this.setEnvConfigOption("RMI_HOSTNAME");
    }

    private final void setEnvConfigOption(String opt) {
        String property = System.getProperties().getProperty(opt);
        String env = System.getenv(opt);
        String setOpt = null;
        if (null != env && env.trim().length() > 0) {
            setOpt = env;
        } else if (null != property && property.trim().length() > 0) {
            setOpt = property;
        }
        if (setOpt != null && opt.equals("RMI_HOSTNAME")) {
            AbstractRmiCLI.setRMI_HOSTNAME(setOpt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public R execute(String[] args) {
        options = this.newOptions();
        error = true;
        try {
            block37: {
                options.addOption("h", "help", false, "Prints a help text");
                options.addOption("s", "server", true, "The optional RMI server (default: localhost)");
                options.addOption("p", "port", true, "The optional RMI port (default:1099)");
                options.addOption(new Option(null, "responsetimeout", true, "The optional response timeout in seconds when reading data from server (default: 0s; infinite)"));
                requiresAdministrativePermission = this.requiresAdministrativePermission();
                if (requiresAdministrativePermission) {
                    options.addOption("A", "adminuser", true, "Admin username");
                    options.addOption("P", "adminpass", true, "Admin password");
                }
                this.addOptions(options);
                parser = new PosixParser();
                cmd = parser.parse((Options)options, args);
                if (cmd.hasOption('h')) {
                    this.printHelp(options);
                    System.exit(0);
                    var7_16 = null;
                    return var7_16;
                }
                optRmiHostName = null;
                if (cmd.hasOption('p')) {
                    optPort = this.parsePort('p', 1099, cmd, options);
                    optServer = cmd.getOptionValue('s');
                    if (optPort > 0 || null != optServer) {
                        optRmiHostName = "rmi://" + (null == optServer ? "localhost" : optServer) + ":" + (optPort > 0 ? optPort : 1099) + "/";
                    }
                }
                if (cmd.hasOption("responsetimeout") && (responseTimeout = this.parseInt("responsetimeout", 0, cmd, (Options)options)) > 0) {
                    System.setProperty("sun.rmi.transport.tcp.responseTimeout", Integer.toString(responseTimeout * 1000));
                }
                this.checkOptions(cmd, options);
                retval = null;
                if (!requiresAdministrativePermission || !this.isAuthEnabled(authenticator = this.authenticatorStub(optRmiHostName))) ** GOTO lbl56
                adminLogin = cmd.getOptionValue('A');
                if (!Strings.isEmpty((String)adminLogin)) break block37;
                System.out.println("You must provide administrative credentials to proceed.");
                this.printHelp(options);
                System.exit(-1);
                var11_26 = null;
                return var11_26;
            }
            adminPassword = cmd.getOptionValue('P');
            if (Strings.isEmpty((String)adminPassword)) {
                System.out.println("You must provide administrative credentials to proceed.");
                this.printHelp(options);
                System.exit(-1);
                var12_28 = null;
                return var12_28;
            }
            try {
                this.administrativeAuth(adminLogin, adminPassword, cmd, authenticator);
lbl56:
                // 2 sources

                retval = this.invoke((Options)options, cmd, optRmiHostName);
            }
            catch (MalformedURLException x) {
                throw x;
            }
            catch (NotBoundException x) {
                throw x;
            }
            catch (ConnectException x) {
                throw x;
            }
            catch (Exception e) {
                t = e.getCause();
                throw new ExecutionFault(null == t ? e : t);
            }
            error = false;
            var9_20 = retval;
            return var9_20;
        }
        catch (ExecutionFault e) {
            t = e.getCause();
            message = t.getMessage();
            System.err.println(null == message ? "An error occurred." : message);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            this.printHelp(options);
        }
        catch (NotBoundException e) {
            System.err.println("Remote stub not found: " + e.getMessage());
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
        }
        catch (ConnectException e) {
            System.err.println("Unable to connect to server");
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
        }
        catch (RuntimeException e) {
            message = e.getMessage();
            clazzName = e.getClass().getName();
            System.err.println("A runtime error occurred: " + (null == message ? clazzName : clazzName + ": " + message));
        }
        catch (Error e) {
            message = e.getMessage();
            clazzName = e.getClass().getName();
            System.err.println("A JVM problem occurred: " + (null == message ? clazzName : clazzName + ": " + message));
        }
        catch (Throwable t) {
            message = t.getMessage();
            clazzName = t.getClass().getName();
            System.err.println("A JVM problem occurred: " + (null == message ? clazzName : clazzName + ": " + message));
        }
        finally {
            if (error) {
                System.exit(1);
            }
        }
        return null;
    }

    protected RemoteAuthenticator authenticatorStub(String optRmiHostName) throws RemoteException, MalformedURLException, NotBoundException {
        return (RemoteAuthenticator)AbstractRmiCLI.getRmiStub(optRmiHostName, RemoteAuthenticator.RMI_NAME);
    }

    protected boolean isAuthEnabled(RemoteAuthenticator authenticator) throws RemoteException {
        return !authenticator.isMasterAuthenticationDisabled();
    }

    protected abstract void administrativeAuth(String var1, String var2, CommandLine var3, RemoteAuthenticator var4) throws RemoteException;

    @Override
    protected abstract void addOptions(Options var1);

    @Override
    protected abstract R invoke(Options var1, CommandLine var2, String var3) throws Exception;

    protected static <Stub extends Remote> Stub getRmiStub(String name) throws MalformedURLException, RemoteException, NotBoundException {
        return AbstractRmiCLI.getRmiStub(RMI_HOSTNAME.get(), name);
    }

    protected static <Stub extends Remote> Stub getRmiStub(String optRmiHostName, String name) throws MalformedURLException, RemoteException, NotBoundException {
        String host = optRmiHostName;
        if (null == host) {
            host = RMI_HOSTNAME.get();
        }
        if (!host.startsWith("rmi://")) {
            host = "rmi://" + host;
        }
        if (!host.endsWith("/")) {
            host = host + "/";
        }
        Remote stub = Naming.lookup(host + name);
        return (Stub)stub;
    }
}

