/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.json.FileMetadataParser;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileParserTest
extends TestCase {
    public void testParse() throws JSONException, OXException {
        JSONObject object = new JSONObject();
        object.put("categories", (Object)new JSONArray("['cat1', 'cat2', 'cat3']"));
        object.put("color_label", 12);
        object.put("creation_date", 1337);
        object.put("created_by", 13);
        object.put("description", (Object)"description");
        object.put("file_md5sum", (Object)"12345");
        object.put("file_mimetype", (Object)"mime/type");
        object.put("file_size", 1337);
        object.put("filename", (Object)"filename");
        object.put("folder_id", (Object)"12");
        object.put("id", (Object)"23");
        object.put("last_modified", 1337);
        object.put("locked_until", 1337);
        object.put("modified_by", 14);
        object.put("number_of_versions", 3000);
        object.put("title", (Object)"nice title");
        object.put("url", (Object)"http://some.url");
        object.put("version", 33);
        object.put("version_comment", (Object)"This is the best version");
        File file = FileMetadataParser.getInstance().parse(object);
        FileParserTest.assertNotNull((Object)file);
        FileParserTest.assertEquals((String)"cat1, cat2, cat3", (String)file.getCategories());
        FileParserTest.assertEquals((int)12, (int)file.getColorLabel());
        FileParserTest.assertEquals((Object)new Date(1337L), (Object)file.getCreated());
        FileParserTest.assertEquals((int)13, (int)file.getCreatedBy());
        FileParserTest.assertEquals((String)"description", (String)file.getDescription());
        FileParserTest.assertEquals((String)"12345", (String)file.getFileMD5Sum());
        FileParserTest.assertEquals((String)"mime/type", (String)file.getFileMIMEType());
        FileParserTest.assertEquals((long)1337L, (long)file.getFileSize());
        FileParserTest.assertEquals((String)"filename", (String)file.getFileName());
        FileParserTest.assertEquals((String)"12", (String)file.getFolderId());
        FileParserTest.assertEquals((String)"23", (String)file.getId());
        FileParserTest.assertEquals((Object)new Date(1337L), (Object)file.getLastModified());
        FileParserTest.assertEquals((Object)new Date(1337L), (Object)file.getLockedUntil());
        FileParserTest.assertEquals((int)14, (int)file.getModifiedBy());
        FileParserTest.assertEquals((int)3000, (int)file.getNumberOfVersions());
        FileParserTest.assertEquals((String)"nice title", (String)file.getTitle());
        FileParserTest.assertEquals((String)"http://some.url", (String)file.getURL());
        FileParserTest.assertEquals((Object)33, (Object)file.getVersion());
        FileParserTest.assertEquals((String)"This is the best version", (String)file.getVersionComment());
    }

    public void testFindFields() throws JSONException {
        JSONObject object = new JSONObject();
        object.put("categories", (Object)new JSONArray("['cat1', 'cat2', 'cat3']"));
        object.put("color_label", 12);
        object.put("description", (Object)"description");
        object.put("filename", (Object)"filename");
        object.put("folder_id", (Object)"12");
        object.put("modified_by", 14);
        object.put("number_of_versions", 3000);
        object.put("version", 33);
        object.put("version_comment", (Object)"This is the best version");
        List fields = FileMetadataParser.getInstance().getFields(object);
        for (File.Field field : EnumSet.of(File.Field.CATEGORIES, new File.Field[]{File.Field.COLOR_LABEL, File.Field.DESCRIPTION, File.Field.FILENAME, File.Field.FOLDER_ID, File.Field.MODIFIED_BY, File.Field.NUMBER_OF_VERSIONS, File.Field.VERSION, File.Field.VERSION_COMMENT})) {
            FileParserTest.assertTrue((String)("Missing field " + field), (boolean)fields.contains(field));
        }
    }
}

